/*
 * Decompiled with CFR 0.152.
 */
package dev.runabout;

import dev.runabout.DefaultCallerSupplier;
import dev.runabout.JsonObject;
import dev.runabout.JsonObjectImpl;
import dev.runabout.RunaboutException;
import dev.runabout.RunaboutSerializer;
import dev.runabout.RunaboutService;
import dev.runabout.RunaboutServiceImpl;
import dev.runabout.RunaboutUtils;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class RunaboutServiceBuilder<T extends JsonObject> {
    private boolean excludeSuper = false;
    private Supplier<Method> callerSupplier;
    private Set<Class<?>> callerClassBlacklist;
    private RunaboutSerializer customSerializer;
    private Consumer<Throwable> throwableConsumer;
    private Supplier<String> datetimeSupplier;
    private Function<Method, String> methodToStringFunction;
    private Predicate<StackWalker.StackFrame> stackFramePredicate;
    private final Supplier<T> jsonFactory;

    public static RunaboutServiceBuilder<JsonObject> getDefaultBuilder() {
        return new RunaboutServiceBuilder<JsonObject>(new JsonObjectImpl.JsonFactoryImpl());
    }

    public RunaboutServiceBuilder(Supplier<T> jsonFactory) {
        this.jsonFactory = jsonFactory;
    }

    public RunaboutServiceBuilder<T> setCallerSupplier(Supplier<Method> callerSupplier) {
        this.callerSupplier = Objects.requireNonNull(callerSupplier, "Caller supplier cannot be null.");
        return this;
    }

    public RunaboutServiceBuilder<T> setCallerClassBlacklist(Set<Class<?>> callerClassBlacklist) {
        this.callerClassBlacklist = Objects.requireNonNull(callerClassBlacklist, "Caller class blacklist cannot be null.");
        return this;
    }

    public RunaboutServiceBuilder<T> setCustomSerializer(RunaboutSerializer customSerializer) {
        this.customSerializer = Objects.requireNonNull(customSerializer, "Custom serializer cannot be null.");
        return this;
    }

    public RunaboutServiceBuilder<T> setThrowableConsumer(Consumer<Throwable> throwableConsumer) {
        this.throwableConsumer = Objects.requireNonNull(throwableConsumer, "Throwable consumer cannot be null.");
        return this;
    }

    public RunaboutServiceBuilder<T> setExcludeSuper(boolean excludeSuper) {
        this.excludeSuper = excludeSuper;
        return this;
    }

    public RunaboutServiceBuilder<T> setDatetimeSupplier(Supplier<String> datetimeSupplier) {
        this.datetimeSupplier = datetimeSupplier;
        return this;
    }

    public RunaboutServiceBuilder<T> setMethodToStringFunction(Function<Method, String> methodToStringFunction) {
        this.methodToStringFunction = methodToStringFunction;
        return this;
    }

    public RunaboutServiceBuilder<T> setStackFramePredicate(Predicate<StackWalker.StackFrame> stackFramePredicate) {
        this.stackFramePredicate = Objects.requireNonNull(stackFramePredicate, "Predicate cannot be null.");
        return this;
    }

    public RunaboutService<T> build() {
        if (this.callerClassBlacklist != null && this.stackFramePredicate != null) {
            throw new RunaboutException("Caller class blacklist and stack frame predicate setters are mutually exclusive.");
        }
        Predicate defaultCallerSupplierPredicate = Optional.ofNullable(this.stackFramePredicate).orElseGet(() -> Optional.ofNullable(this.callerClassBlacklist).map(DefaultCallerSupplier::getCallerClassPredicate).orElse(null));
        if (this.callerSupplier != null && defaultCallerSupplierPredicate != null) {
            throw new RunaboutException("Caller supplier and caller predicate/blacklist setters are mutually exclusive.");
        }
        Supplier callerSupplierFinal = Optional.ofNullable(this.callerSupplier).orElseGet(() -> {
            Predicate<StackWalker.StackFrame> predicateFinal = Optional.ofNullable(defaultCallerSupplierPredicate).orElse(stackFrame -> true);
            return new DefaultCallerSupplier(predicateFinal);
        });
        RunaboutSerializer customSerializerFinal = Optional.ofNullable(this.customSerializer).orElseGet(RunaboutSerializer::getSerializer);
        Consumer<Throwable> throwableConsumerFinal = Optional.ofNullable(this.throwableConsumer).orElse(RunaboutServiceBuilder::defaultThrowableConsumer);
        Supplier datetimeSupplierFinal = Optional.ofNullable(this.datetimeSupplier).orElseGet(() -> () -> Instant.now().toString());
        Function<Method, String> methodToStringFunctionFinal = Optional.ofNullable(this.methodToStringFunction).orElse(RunaboutUtils::methodToRunaboutString);
        return new RunaboutServiceImpl<T>(this.excludeSuper, throwableConsumerFinal, callerSupplierFinal, customSerializerFinal, this.jsonFactory, datetimeSupplierFinal, methodToStringFunctionFinal);
    }

    private static void defaultThrowableConsumer(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
    }
}

