/*
 * Decompiled with CFR 0.152.
 */
package dev.runabout;

import dev.runabout.RunaboutService;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;

class DefaultCallerSupplier
implements Supplier<Method> {
    private static final Set<StackWalker.Option> options = Set.of(StackWalker.Option.RETAIN_CLASS_REFERENCE, StackWalker.Option.SHOW_REFLECT_FRAMES);
    private static final String LAMBDA_KEYWORD = "lambda$";
    private final Predicate<StackWalker.StackFrame> stackFramePredicate;

    DefaultCallerSupplier(Predicate<StackWalker.StackFrame> stackFramePredicate) {
        this.stackFramePredicate = stackFramePredicate;
    }

    @Override
    public Method get() {
        AtomicBoolean failed = new AtomicBoolean(false);
        AtomicReference method = new AtomicReference();
        StackWalker.getInstance(options).forEach(stackFrame -> {
            if (method.get() == null && !failed.get() && !DefaultCallerSupplier.isLambdaMethod(stackFrame) && !DefaultCallerSupplier.isAnonymousCaller(stackFrame) && stackFrame.getDeclaringClass().getPackage() != RunaboutService.class.getPackage() && this.stackFramePredicate.test((StackWalker.StackFrame)stackFrame)) {
                try {
                    method.set(DefaultCallerSupplier.getMethodFromStackFrame(stackFrame));
                }
                catch (NoSuchMethodException | NullPointerException | SecurityException e) {
                    failed.set(true);
                }
            }
        });
        return (Method)method.get();
    }

    public static Predicate<StackWalker.StackFrame> getCallerClassPredicate(Set<Class<?>> callerClassBlackList) {
        return stackFrame -> stackFrame != null && stackFrame.getDeclaringClass() != null && !callerClassBlackList.contains(stackFrame.getDeclaringClass());
    }

    private static boolean isLambdaMethod(StackWalker.StackFrame stackFrame) {
        return stackFrame != null && stackFrame.getMethodName() != null && stackFrame.getMethodName().contains(LAMBDA_KEYWORD);
    }

    private static boolean isAnonymousCaller(StackWalker.StackFrame stackFrame) {
        return stackFrame != null && stackFrame.getDeclaringClass() != null && stackFrame.getDeclaringClass().isAnonymousClass();
    }

    private static Method getMethodFromStackFrame(StackWalker.StackFrame stackFrame) throws NoSuchMethodException {
        Class<?> clazz = Objects.requireNonNull(stackFrame.getDeclaringClass());
        String methodName = Objects.requireNonNull(stackFrame.getMethodName());
        MethodType methodType = Objects.requireNonNull(stackFrame.getMethodType());
        Class<?>[] parameterTypes = Objects.requireNonNull(methodType.parameterArray());
        return clazz.getDeclaredMethod(methodName, parameterTypes);
    }
}

