/*
 * Decompiled with CFR 0.152.
 */
package dev.runabout;

import java.io.InputStream;
import java.util.Properties;

class RunaboutProperties {
    private static final String PROPERTIES_FILE = "runabout.properties";
    private static RunaboutProperties INSTANCE;
    private final String JSON_CONTRACT_VERSION;

    private RunaboutProperties() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Properties properties = new Properties();
        try (InputStream inputStream = loader.getResourceAsStream(PROPERTIES_FILE);){
            properties.load(inputStream);
            this.JSON_CONTRACT_VERSION = properties.getProperty("JSON_CONTRACT_VERSION");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load properties file: runabout.properties", e);
        }
    }

    public String getJsonContractVersion() {
        return this.JSON_CONTRACT_VERSION;
    }

    static synchronized RunaboutProperties getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RunaboutProperties();
        }
        return INSTANCE;
    }
}

