/*
 * Decompiled with CFR 0.152.
 */
package dev.runabout;

import dev.runabout.JsonObject;
import dev.runabout.RunaboutException;
import dev.runabout.RunaboutUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;

class JsonObjectImpl
extends HashMap<String, Object>
implements JsonObject {
    JsonObjectImpl() {
    }

    @Override
    public JsonObject put(String key, Boolean value) {
        super.put(key, value);
        return this;
    }

    @Override
    public JsonObject put(String key, Number value) {
        super.put(key, value);
        return this;
    }

    @Override
    public JsonObject put(String key, String value) {
        super.put(key, value);
        return this;
    }

    @Override
    public JsonObject put(String key, JsonObject value) {
        super.put(key, value);
        return this;
    }

    @Override
    public <T> JsonObject put(String key, Class<T> clazz, List<T> values) {
        if (clazz != String.class && clazz != Boolean.class && this.doesNotImplement(clazz, Number.class) && this.doesNotImplement(clazz, JsonObject.class)) {
            throw new RunaboutException(String.format("Unknown list type for Runabout JsonObject: [%1$s]", clazz.getCanonicalName()));
        }
        super.put(key, values);
        return this;
    }

    private boolean doesNotImplement(Class<?> clazz, Class<?> interfaceClass) {
        return clazz != interfaceClass && !Set.of(clazz.getInterfaces()).contains(interfaceClass);
    }

    @Override
    public String toJson() {
        StringJoiner commaJoiner = new StringJoiner(",");
        for (Map.Entry entry : this.entrySet()) {
            StringBuilder singleKvp = new StringBuilder().append("\"").append(RunaboutUtils.escapeQuotesOneLayer((String)entry.getKey())).append("\":").append(JsonObjectImpl.valueToString(entry.getValue()));
            commaJoiner.add(singleKvp);
        }
        return "{" + commaJoiner + "}";
    }

    private static String valueToString(Object value) {
        Object string;
        if (value instanceof JsonObject) {
            string = ((JsonObject)value).toJson();
        } else if (value instanceof String) {
            string = "\"" + RunaboutUtils.escapeQuotesOneLayer((String)value) + "\"";
        } else if (value instanceof List) {
            StringJoiner commaJoiner = new StringJoiner(",");
            ((List)value).forEach((? super T innerValue) -> commaJoiner.add(JsonObjectImpl.valueToString(innerValue)));
            string = "[" + commaJoiner + "]";
        } else {
            string = Optional.ofNullable(value).map(Object::toString).orElse("null");
        }
        return string;
    }
}

