/*
 * Decompiled with CFR 0.152.
 */
package dev.runabout;

import dev.runabout.MethodResolver;
import dev.runabout.MethodResolverImpl;
import java.util.Set;
import java.util.function.Predicate;

public class MethodResolverBuilder {
    private Set<Class<?>> callerClassBlacklist;
    private Predicate<StackWalker.StackFrame> stackFramePredicate;

    public MethodResolverBuilder setCallerClassBlacklist(Set<Class<?>> callerClassBlacklist) {
        this.callerClassBlacklist = callerClassBlacklist;
        return this;
    }

    public MethodResolverBuilder setStackFramePredicate(Predicate<StackWalker.StackFrame> stackFramePredicate) {
        this.stackFramePredicate = stackFramePredicate;
        return this;
    }

    public MethodResolver build() {
        Predicate<StackWalker.StackFrame> predicate = s -> true;
        if (this.stackFramePredicate != null) {
            predicate = predicate.and(this.stackFramePredicate);
        }
        if (this.callerClassBlacklist != null && !this.callerClassBlacklist.isEmpty()) {
            predicate = predicate.and(stackFrame -> {
                Class<?> declaringClass = stackFrame.getDeclaringClass();
                return !this.callerClassBlacklist.contains(declaringClass);
            });
        }
        return new MethodResolverImpl(predicate);
    }
}

