/*
 * Decompiled with CFR 0.152.
 */
package dev.runabout;

import dev.runabout.RunaboutApi;
import dev.runabout.RunaboutApiImpl;
import dev.runabout.RunaboutListener;
import dev.runabout.RunaboutScenario;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Supplier;

public class RunaboutApiBuilder {
    private URI uri = URI.create("https://ingest.runabout.dev/scenarios");
    private long timeout = 30000L;
    private Executor executor;
    private RunaboutListener listener;
    private Queue<RunaboutScenario> queue = new ArrayBlockingQueue<RunaboutScenario>(1000);
    private final Supplier<String> tokenSupplier;

    public RunaboutApiBuilder(Supplier<String> tokenSupplier) {
        this.tokenSupplier = tokenSupplier;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public RunaboutApiBuilder setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public RunaboutApiBuilder setExecutor(Executor executor) {
        this.executor = Objects.requireNonNull(executor, "Executor cannot be null");
        return this;
    }

    public Queue<RunaboutScenario> getQueue() {
        return this.queue;
    }

    public RunaboutApiBuilder setQueue(Queue<RunaboutScenario> queue) {
        this.queue = Objects.requireNonNull(queue, "Queue size cannot be null");
        return this;
    }

    public URI getUri() {
        return this.uri;
    }

    public RunaboutApiBuilder setUri(URI uri) {
        this.uri = uri;
        return this;
    }

    public RunaboutListener getListener() {
        return this.listener;
    }

    public RunaboutApiBuilder setListener(RunaboutListener listener) {
        this.listener = listener;
        return this;
    }

    public Supplier<String> getTokenSupplier() {
        return this.tokenSupplier;
    }

    public RunaboutApi build() {
        this.executor = Optional.ofNullable(this.executor).orElseGet(() -> Executors.newFixedThreadPool(1));
        return new RunaboutApiImpl(this);
    }
}

