/*
 * Decompiled with CFR 0.152.
 */
package dev.runabout;

import dev.runabout.RunaboutInput;
import dev.runabout.RunaboutSerializer;
import dev.runabout.RunaboutUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

class DefaultSerializer {
    private static final Map<Class<?>, TypedSerializer<?>> serializers = Map.ofEntries(Map.entry(String.class, DefaultSerializer::stringSerializer), Map.entry(Boolean.class, DefaultSerializer::primitiveSerializer), Map.entry(Integer.class, DefaultSerializer::primitiveSerializer), Map.entry(Long.class, DefaultSerializer::primitiveSerializer), Map.entry(Float.class, DefaultSerializer::primitiveSerializer), Map.entry(Double.class, DefaultSerializer::primitiveSerializer), Map.entry(Byte.class, DefaultSerializer::primitiveSerializer), Map.entry(Short.class, DefaultSerializer::primitiveSerializer), Map.entry(Character.class, DefaultSerializer::charSerializer));
    private static final RunaboutInput NULL_INPUT = RunaboutInput.of("null", Collections.emptySet());
    private static final RunaboutInput EMPTY_INPUT = RunaboutInput.of("", Collections.emptySet());
    private static final DefaultSerializer INSTANCE = new DefaultSerializer();

    public static DefaultSerializer getInstance() {
        return INSTANCE;
    }

    private DefaultSerializer() {
    }

    public <T> RunaboutInput toRunaboutGenericRecursive(T object, RunaboutSerializer recursiveSerializer) {
        if (object == null) {
            return NULL_INPUT;
        }
        RunaboutInput input = null;
        if (object instanceof Map) {
            input = DefaultSerializer.mapSerializer((Map)object, recursiveSerializer);
        } else if (object instanceof Collection) {
            input = DefaultSerializer.collectionSerializer((Collection)object, recursiveSerializer);
        }
        return Optional.ofNullable(input).orElseGet(() -> this.toRunaboutGeneric(object));
    }

    <T> RunaboutInput toRunaboutGeneric(T object) {
        if (object == null) {
            return NULL_INPUT;
        }
        RunaboutInput input = null;
        if (object instanceof Enum) {
            input = DefaultSerializer.enumSerializer((Enum)object);
        }
        return Optional.ofNullable(input).orElseGet(() -> Optional.ofNullable(serializers.get(object.getClass())).map(serializer -> (RunaboutInput)serializer.apply(object)).orElse(EMPTY_INPUT));
    }

    static RunaboutInput getNullInput() {
        return NULL_INPUT;
    }

    static RunaboutInput getEmptyInput() {
        return EMPTY_INPUT;
    }

    private static RunaboutInput collectionSerializer(Collection<?> collection, RunaboutSerializer recursiveSerializer) {
        RunaboutInput input = null;
        if (collection instanceof List) {
            input = DefaultSerializer.listSerializer((List)collection, recursiveSerializer);
        } else if (collection instanceof Set) {
            input = DefaultSerializer.setSerializer((Set)collection, recursiveSerializer);
        }
        return input;
    }

    private static RunaboutInput mapSerializer(Map<?, ?> map, RunaboutSerializer recursiveSerializer) {
        if (map.isEmpty()) {
            return RunaboutInput.of("new HashMap<>()", Set.of(HashMap.class.getCanonicalName()));
        }
        StringBuilder builder = new StringBuilder();
        HashSet<String> allDependencies = new HashSet<String>();
        allDependencies.add(HashMap.class.getCanonicalName());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            RunaboutInput serialKey = recursiveSerializer.toRunaboutGeneric(entry.getKey());
            RunaboutInput serialValue = recursiveSerializer.toRunaboutGeneric(entry.getValue());
            if (serialKey == null || serialKey.getEval() == null || serialKey.getEval().isEmpty() || serialValue == null || serialValue.getEval() == null || serialValue.getEval().isEmpty()) {
                return EMPTY_INPUT;
            }
            String entryString = "put(" + serialKey.getEval() + ", " + serialValue.getEval() + "); ";
            builder.append(entryString);
            allDependencies.addAll(serialKey.getDependencies());
            allDependencies.addAll(serialValue.getDependencies());
        }
        return RunaboutInput.of("new HashMap<>() {{ " + builder + "}}", allDependencies);
    }

    private static RunaboutInput listSerializer(List<?> list, RunaboutSerializer recursiveSerializer) {
        if (list.isEmpty()) {
            return RunaboutInput.of("new ArrayList<>()", Set.of(ArrayList.class.getCanonicalName()));
        }
        StringBuilder builder = new StringBuilder();
        HashSet<String> allDependencies = new HashSet<String>();
        allDependencies.add(ArrayList.class.getCanonicalName());
        for (Object item : list) {
            RunaboutInput serialItem = recursiveSerializer.toRunaboutGeneric(item);
            if (serialItem == null || serialItem.getEval() == null || serialItem.getEval().isEmpty()) {
                return EMPTY_INPUT;
            }
            builder.append("add(").append(serialItem.getEval()).append("); ");
            allDependencies.addAll(serialItem.getDependencies());
        }
        return RunaboutInput.of("new ArrayList<>() {{ " + builder + "}}", allDependencies);
    }

    private static RunaboutInput setSerializer(Set<?> set, RunaboutSerializer recursiveSerializer) {
        if (set.isEmpty()) {
            return RunaboutInput.of("new HashSet<>()", Set.of(HashSet.class.getCanonicalName()));
        }
        StringBuilder builder = new StringBuilder();
        HashSet<String> allDependencies = new HashSet<String>();
        allDependencies.add(HashSet.class.getCanonicalName());
        for (Object item : set) {
            RunaboutInput serialItem = recursiveSerializer.toRunaboutGeneric(item);
            if (serialItem == null || serialItem.getEval() == null || serialItem.getEval().isEmpty()) {
                return EMPTY_INPUT;
            }
            builder.append("add(").append(serialItem.getEval()).append("); ");
            allDependencies.addAll(serialItem.getDependencies());
        }
        return RunaboutInput.of("new HashSet<>() {{ " + builder + "}}", allDependencies);
    }

    private static RunaboutInput stringSerializer(String string) {
        return RunaboutInput.of("\"" + RunaboutUtils.escapeQuotesOneLayer(string) + "\"", Collections.emptySet());
    }

    private static RunaboutInput primitiveSerializer(Object object) {
        String primitive = object instanceof Integer ? "int" : object.getClass().getSimpleName().toLowerCase();
        return RunaboutInput.of("(" + primitive + ") " + object, Collections.emptySet());
    }

    static RunaboutInput charSerializer(Object object) {
        return RunaboutInput.of("'" + object + "'", Collections.emptySet());
    }

    private static RunaboutInput enumSerializer(Enum<?> e) {
        return RunaboutInput.of(e.getClass().getCanonicalName() + "." + e.name(), Set.of(e.getClass().getCanonicalName()));
    }

    private static interface TypedSerializer<T>
    extends Function<T, RunaboutInput> {
    }
}

