/*
 * Decompiled with CFR 0.152.
 */
package dev.runabout;

import dev.runabout.MethodResolver;
import dev.runabout.RunaboutService;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;

class MethodResolverImpl
implements MethodResolver {
    private static final Set<StackWalker.Option> options = Set.of(StackWalker.Option.RETAIN_CLASS_REFERENCE, StackWalker.Option.SHOW_REFLECT_FRAMES);
    private static final String LAMBDA_KEYWORD = "lambda$";
    private final Predicate<StackWalker.StackFrame> stackFramePredicate;

    MethodResolverImpl() {
        this(stackFrame -> true);
    }

    MethodResolverImpl(Predicate<StackWalker.StackFrame> stackFramePredicate) {
        this.stackFramePredicate = stackFramePredicate;
    }

    @Override
    public Method getMethod() {
        AtomicBoolean failed = new AtomicBoolean(false);
        AtomicReference method = new AtomicReference();
        try {
            StackWalker.getInstance(options).forEach(stackFrame -> {
                if (method.get() == null && !failed.get() && !MethodResolverImpl.isLambdaMethod(stackFrame) && !MethodResolverImpl.isAnonymousCaller(stackFrame) && stackFrame.getDeclaringClass().getPackage() != RunaboutService.class.getPackage() && this.stackFramePredicate.test((StackWalker.StackFrame)stackFrame)) {
                    try {
                        method.set(MethodResolverImpl.getMethodFromStackFrame(stackFrame));
                        throw new ExitStackWalkerException();
                    }
                    catch (NoSuchMethodException | NullPointerException | SecurityException e) {
                        failed.set(true);
                    }
                }
            });
        }
        catch (ExitStackWalkerException exitStackWalkerException) {
            // empty catch block
        }
        return (Method)method.get();
    }

    private static boolean isLambdaMethod(StackWalker.StackFrame stackFrame) {
        return stackFrame != null && stackFrame.getMethodName() != null && stackFrame.getMethodName().contains(LAMBDA_KEYWORD);
    }

    private static boolean isAnonymousCaller(StackWalker.StackFrame stackFrame) {
        return stackFrame != null && stackFrame.getDeclaringClass() != null && stackFrame.getDeclaringClass().isAnonymousClass();
    }

    private static Method getMethodFromStackFrame(StackWalker.StackFrame stackFrame) throws NoSuchMethodException {
        Class<?> clazz = Objects.requireNonNull(stackFrame.getDeclaringClass());
        String methodName = Objects.requireNonNull(stackFrame.getMethodName());
        MethodType methodType = Objects.requireNonNull(stackFrame.getMethodType());
        Class<?>[] parameterTypes = Objects.requireNonNull(methodType.parameterArray());
        return clazz.getDeclaredMethod(methodName, parameterTypes);
    }

    private static class ExitStackWalkerException
    extends RuntimeException {
        private ExitStackWalkerException() {
        }
    }
}

