/*
 * Decompiled with CFR 0.152.
 */
package dk.nversion.copybook.codegen;

import dk.nversion.copybook.codegen.CopyBookConverter;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class CodeGenMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputPath;
    @Parameter(required=true)
    private File inputPath;
    @Parameter(defaultValue="^.*$")
    private String inputFilter;
    @Parameter(defaultValue="java")
    private String language;
    @Parameter(defaultValue="UTF-8")
    private String charset;
    @Parameter(defaultValue="none")
    private String accessor;
    @Parameter(defaultValue="nested")
    private String subclass;
    @Parameter(defaultValue="mypackage")
    private String packageName;
    @Parameter(defaultValue="true")
    private boolean addCompileSourceRoot = true;
    @Parameter(readonly=true, required=true, defaultValue="${project}")
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        try {
            CopyBookConverter converter = new CopyBookConverter();
            Path outPath = Paths.get(this.outputPath.getCanonicalPath(), "generated-sources");
            converter.convertFiles(this.inputPath.getCanonicalPath(), Pattern.compile(this.inputFilter), outPath.toString(), this.packageName, this.accessor, this.charset, this.subclass);
            if (this.addCompileSourceRoot) {
                this.project.addCompileSourceRoot(this.outputPath.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getClassName(File file) {
        String name = file.getName();
        try {
            return Character.toUpperCase(name.charAt(0)) + name.substring(1, name.lastIndexOf("."));
        }
        catch (Exception e) {
            return "";
        }
    }
}

