/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.cloudsql.postgres;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Metadata;
import io.cdap.cdap.api.annotation.MetadataProperty;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.api.data.batch.Output;
import io.cdap.cdap.api.data.batch.OutputFormatProvider;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.plugin.PluginConfig;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import io.cdap.cdap.etl.api.batch.BatchContext;
import io.cdap.cdap.etl.api.batch.BatchSinkContext;
import io.cdap.plugin.cloudsql.postgres.CloudSQLPostgreSQLConnectorConfig;
import io.cdap.plugin.common.Asset;
import io.cdap.plugin.common.ConfigUtil;
import io.cdap.plugin.common.LineageRecorder;
import io.cdap.plugin.common.batch.sink.SinkOutputFormatProvider;
import io.cdap.plugin.db.DBRecord;
import io.cdap.plugin.db.SchemaReader;
import io.cdap.plugin.db.config.AbstractDBSpecificSinkConfig;
import io.cdap.plugin.db.sink.AbstractDBSink;
import io.cdap.plugin.db.sink.FieldsValidator;
import io.cdap.plugin.postgres.PostgresDBRecord;
import io.cdap.plugin.postgres.PostgresETLDBOutputFormat;
import io.cdap.plugin.postgres.PostgresFieldsValidator;
import io.cdap.plugin.postgres.PostgresSchemaReader;
import io.cdap.plugin.util.CloudSQLUtil;
import io.cdap.plugin.util.DBUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@Plugin(type="batchsink")
@Name(value="CloudSQLPostgreSQL")
@Description(value="Writes records to a CloudSQL PostgreSQL table. Each record will be written in a row in the table")
@Metadata(properties={@MetadataProperty(key="connector", value="CloudSQLPostgreSQL")})
public class CloudSQLPostgreSQLSink
extends AbstractDBSink<CloudSQLPostgreSQLSinkConfig> {
    private static final Character ESCAPE_CHAR = Character.valueOf('\"');
    private final CloudSQLPostgreSQLSinkConfig cloudsqlPostgresqlSinkConfig;

    public CloudSQLPostgreSQLSink(CloudSQLPostgreSQLSinkConfig cloudsqlPostgresqlSinkConfig) {
        super((PluginConfig)cloudsqlPostgresqlSinkConfig);
        this.cloudsqlPostgresqlSinkConfig = cloudsqlPostgresqlSinkConfig;
    }

    public void configurePipeline(PipelineConfigurer pipelineConfigurer) {
        FailureCollector failureCollector = pipelineConfigurer.getStageConfigurer().getFailureCollector();
        if (!this.cloudsqlPostgresqlSinkConfig.containsMacro("instanceType") && !this.cloudsqlPostgresqlSinkConfig.containsMacro("connectionName")) {
            CloudSQLUtil.checkConnectionName((FailureCollector)failureCollector, (String)this.cloudsqlPostgresqlSinkConfig.connection.getInstanceType(), (String)this.cloudsqlPostgresqlSinkConfig.connection.getConnectionName());
        }
        super.configurePipeline(pipelineConfigurer);
    }

    protected SchemaReader getSchemaReader() {
        return new PostgresSchemaReader();
    }

    protected void addOutputContext(BatchSinkContext context) {
        context.addOutput(Output.of((String)this.cloudsqlPostgresqlSinkConfig.getReferenceName(), (OutputFormatProvider)new SinkOutputFormatProvider(PostgresETLDBOutputFormat.class, this.getConfiguration())));
    }

    protected DBRecord getDBRecord(StructuredRecord output) {
        return new PostgresDBRecord(output, this.columnTypes, this.cloudsqlPostgresqlSinkConfig.getOperationName(), this.cloudsqlPostgresqlSinkConfig.getRelationTableKey());
    }

    protected void setColumnsInfo(List<Schema.Field> fields) {
        ArrayList<String> columnsList = new ArrayList<String>();
        StringJoiner columnsJoiner = new StringJoiner(",");
        for (Schema.Field field : fields) {
            columnsList.add(field.getName());
            columnsJoiner.add(ESCAPE_CHAR + field.getName() + ESCAPE_CHAR);
        }
        this.columns = Collections.unmodifiableList(columnsList);
        this.dbColumns = columnsJoiner.toString();
    }

    protected FieldsValidator getFieldsValidator() {
        return new PostgresFieldsValidator();
    }

    protected LineageRecorder getLineageRecorder(BatchSinkContext context) {
        String host;
        String location = "";
        if ("private".equalsIgnoreCase(this.cloudsqlPostgresqlSinkConfig.getConnection().getInstanceType())) {
            host = this.cloudsqlPostgresqlSinkConfig.getConnection().getConnectionName();
        } else {
            String[] connectionParams = this.cloudsqlPostgresqlSinkConfig.getConnection().getConnectionName().split(":");
            host = connectionParams[2];
            location = connectionParams[1];
        }
        String fqn = DBUtils.constructFQN((String)"postgres", (String)host, (int)this.cloudsqlPostgresqlSinkConfig.getConnection().getPort(), (String)this.cloudsqlPostgresqlSinkConfig.getConnection().getDatabase(), (String)this.cloudsqlPostgresqlSinkConfig.getReferenceName());
        Asset.Builder assetBuilder = Asset.builder((String)this.cloudsqlPostgresqlSinkConfig.getReferenceName()).setFqn(fqn);
        if (!Strings.isNullOrEmpty((String)location)) {
            assetBuilder.setLocation(location);
        }
        return new LineageRecorder((BatchContext)context, assetBuilder.build());
    }

    public static class CloudSQLPostgreSQLSinkConfig
    extends AbstractDBSpecificSinkConfig {
        @Name(value="useConnection")
        @Nullable
        @Description(value="Whether to use an existing connection.")
        private Boolean useConnection;
        @Name(value="connection")
        @Macro
        @Nullable
        @Description(value="The existing connection to use.")
        private CloudSQLPostgreSQLConnectorConfig connection;
        @Name(value="connectionTimeout")
        @Description(value="The timeout value used for socket connect operations. If connecting to the server takes longer than this value, the connection is broken. The timeout is specified in seconds and a value of zero means that it is disabled")
        @Nullable
        private Integer connectionTimeout;
        @Name(value="transactionIsolationLevel")
        @Description(value="Transaction isolation level for queries run by this sink.")
        @Nullable
        private String transactionIsolationLevel;

        public String getTransactionIsolationLevel() {
            return this.transactionIsolationLevel;
        }

        public String getEscapedTableName() {
            return ESCAPE_CHAR + this.getTableName() + ESCAPE_CHAR;
        }

        public String getEscapedDbSchemaName() {
            return ESCAPE_CHAR + this.getDBSchemaName() + ESCAPE_CHAR;
        }

        public Map<String, String> getDBSpecificArguments() {
            return ImmutableMap.of((Object)"connectionTimeout", (Object)String.valueOf(this.connectionTimeout));
        }

        @Nullable
        protected CloudSQLPostgreSQLConnectorConfig getConnection() {
            return this.connection;
        }

        public void validate(FailureCollector collector) {
            ConfigUtil.validateConnection((PluginConfig)this, (Boolean)this.useConnection, (PluginConfig)this.connection, (FailureCollector)collector);
            super.validate(collector);
        }
    }
}

