/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.cloudsql.postgres;

import com.google.common.base.Strings;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Metadata;
import io.cdap.cdap.api.annotation.MetadataProperty;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.api.plugin.PluginConfig;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import io.cdap.cdap.etl.api.batch.BatchContext;
import io.cdap.cdap.etl.api.batch.BatchSourceContext;
import io.cdap.plugin.cloudsql.postgres.CloudSQLPostgreSQLConnectorConfig;
import io.cdap.plugin.common.Asset;
import io.cdap.plugin.common.ConfigUtil;
import io.cdap.plugin.common.LineageRecorder;
import io.cdap.plugin.db.SchemaReader;
import io.cdap.plugin.db.config.AbstractDBSpecificSourceConfig;
import io.cdap.plugin.db.source.AbstractDBSource;
import io.cdap.plugin.postgres.PostgresDBRecord;
import io.cdap.plugin.postgres.PostgresSchemaReader;
import io.cdap.plugin.util.CloudSQLUtil;
import io.cdap.plugin.util.DBUtils;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;

@Plugin(type="batchsource")
@Name(value="CloudSQLPostgreSQL")
@Description(value="Reads from a CloudSQL PostgreSQL database table(s) using a configurable SQL query. Outputs one record for each row returned by the query.")
@Metadata(properties={@MetadataProperty(key="connector", value="CloudSQLPostgreSQL")})
public class CloudSQLPostgreSQLSource
extends AbstractDBSource<CloudSQLPostgreSQLSourceConfig> {
    private final CloudSQLPostgreSQLSourceConfig cloudsqlPostgresqlSourceConfig;

    public CloudSQLPostgreSQLSource(CloudSQLPostgreSQLSourceConfig cloudsqlPostgresqlSourceConfig) {
        super((PluginConfig)cloudsqlPostgresqlSourceConfig);
        this.cloudsqlPostgresqlSourceConfig = cloudsqlPostgresqlSourceConfig;
    }

    public void configurePipeline(PipelineConfigurer pipelineConfigurer) {
        FailureCollector failureCollector = pipelineConfigurer.getStageConfigurer().getFailureCollector();
        if (!this.cloudsqlPostgresqlSourceConfig.containsMacro("instanceType") && !this.cloudsqlPostgresqlSourceConfig.containsMacro("connectionName")) {
            CloudSQLUtil.checkConnectionName((FailureCollector)failureCollector, (String)this.cloudsqlPostgresqlSourceConfig.connection.getInstanceType(), (String)this.cloudsqlPostgresqlSourceConfig.connection.getConnectionName());
        }
        super.configurePipeline(pipelineConfigurer);
    }

    protected SchemaReader getSchemaReader() {
        return new PostgresSchemaReader();
    }

    protected Class<? extends DBWritable> getDBRecordType() {
        return PostgresDBRecord.class;
    }

    protected String createConnectionString() {
        if ("private".equalsIgnoreCase(this.cloudsqlPostgresqlSourceConfig.connection.getInstanceType())) {
            return String.format("jdbc:postgresql://%s:%s/%s", this.cloudsqlPostgresqlSourceConfig.connection.getConnectionName(), this.cloudsqlPostgresqlSourceConfig.connection.getPort(), this.cloudsqlPostgresqlSourceConfig.connection.getDatabase());
        }
        return String.format("jdbc:postgresql:///%s?cloudSqlInstance=%s&socketFactory=com.google.cloud.sql.postgres.SocketFactory", this.cloudsqlPostgresqlSourceConfig.connection.getDatabase(), this.cloudsqlPostgresqlSourceConfig.connection.getConnectionName());
    }

    protected LineageRecorder getLineageRecorder(BatchSourceContext context) {
        String host;
        String location = "";
        if ("private".equalsIgnoreCase(this.cloudsqlPostgresqlSourceConfig.getConnection().getInstanceType())) {
            host = this.cloudsqlPostgresqlSourceConfig.getConnection().getConnectionName();
        } else {
            String[] connectionParams = this.cloudsqlPostgresqlSourceConfig.getConnection().getConnectionName().split(":");
            host = connectionParams[2];
            location = connectionParams[1];
        }
        String fqn = DBUtils.constructFQN((String)"postgres", (String)host, (int)this.cloudsqlPostgresqlSourceConfig.getConnection().getPort(), (String)this.cloudsqlPostgresqlSourceConfig.getConnection().getDatabase(), (String)this.cloudsqlPostgresqlSourceConfig.getReferenceName());
        Asset.Builder assetBuilder = Asset.builder((String)this.cloudsqlPostgresqlSourceConfig.getReferenceName()).setFqn(fqn);
        if (!Strings.isNullOrEmpty((String)location)) {
            assetBuilder.setLocation(location);
        }
        return new LineageRecorder((BatchContext)context, assetBuilder.build());
    }

    public static class CloudSQLPostgreSQLSourceConfig
    extends AbstractDBSpecificSourceConfig {
        @Name(value="useConnection")
        @Nullable
        @Description(value="Whether to use an existing connection.")
        private Boolean useConnection;
        @Name(value="connection")
        @Macro
        @Nullable
        @Description(value="The existing connection to use.")
        private CloudSQLPostgreSQLConnectorConfig connection;

        protected Map<String, String> getDBSpecificArguments() {
            return Collections.emptyMap();
        }

        public Integer getFetchSize() {
            Integer fetchSize = super.getFetchSize();
            return fetchSize == null ? Integer.parseInt("1000") : fetchSize;
        }

        protected CloudSQLPostgreSQLConnectorConfig getConnection() {
            return this.connection;
        }

        public void validate(FailureCollector collector) {
            ConfigUtil.validateConnection((PluginConfig)this, (Boolean)this.useConnection, (PluginConfig)this.connection, (FailureCollector)collector);
            super.validate(collector);
        }
    }
}

