/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.cloudsql.postgres;

import io.cdap.cdap.api.annotation.Category;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.etl.api.connector.ConnectorSpec;
import io.cdap.cdap.etl.api.connector.ConnectorSpecRequest;
import io.cdap.cdap.etl.api.connector.PluginSpec;
import io.cdap.plugin.cloudsql.postgres.CloudSQLPostgreSQLConnectorConfig;
import io.cdap.plugin.common.ReferenceNames;
import io.cdap.plugin.common.db.DBConnectorPath;
import io.cdap.plugin.common.db.DBPath;
import io.cdap.plugin.db.SchemaReader;
import io.cdap.plugin.db.connector.AbstractDBConnectorConfig;
import io.cdap.plugin.db.connector.AbstractDBSpecificConnector;
import io.cdap.plugin.postgres.PostgresDBRecord;
import io.cdap.plugin.postgres.PostgresSchemaReader;
import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;

@Plugin(type="connector")
@Name(value="CloudSQLPostgreSQL")
@Description(value="Connection to access data in CloudSQL PostgreSQL Server databases using JDBC.")
@Category(value="Database")
public class CloudSQLPostgreSQLConnector
extends AbstractDBSpecificConnector<PostgresDBRecord> {
    public static final String NAME = "CloudSQLPostgreSQL";
    private final CloudSQLPostgreSQLConnectorConfig config;

    public CloudSQLPostgreSQLConnector(CloudSQLPostgreSQLConnectorConfig config) {
        super((AbstractDBConnectorConfig)config);
        this.config = config;
    }

    protected DBConnectorPath getDBConnectorPath(String path) throws IOException {
        return new DBPath(path, true);
    }

    public boolean supportSchema() {
        return true;
    }

    protected Class<? extends DBWritable> getDBRecordType() {
        return PostgresDBRecord.class;
    }

    public StructuredRecord transform(LongWritable longWritable, PostgresDBRecord postgresDBRecord) {
        return postgresDBRecord.getRecord();
    }

    protected SchemaReader getSchemaReader() {
        return new PostgresSchemaReader();
    }

    protected String getTableQuery(String database, String schema, String table) {
        return String.format("SELECT * FROM \"%s\".\"%s\"", schema, table);
    }

    protected String getTableQuery(String database, String schema, String table, int limit) {
        return String.format("SELECT * FROM \"%s\".\"%s\" LIMIT %d", schema, table, limit);
    }

    protected void setConnectorSpec(ConnectorSpecRequest request, DBConnectorPath path, ConnectorSpec.Builder builder) {
        HashMap<String, String> sourceProperties = new HashMap<String, String>();
        HashMap<String, String> sinkProperties = new HashMap<String, String>();
        this.setConnectionProperties(sourceProperties, request);
        this.setConnectionProperties(sinkProperties, request);
        builder.addRelatedPlugin(new PluginSpec(NAME, "batchsource", sourceProperties)).addRelatedPlugin(new PluginSpec(NAME, "batchsink", sinkProperties));
        String schema = path.getSchema();
        if (schema != null) {
            sinkProperties.put("dbSchemaName", schema);
        }
        sourceProperties.put("numSplits", "1");
        sourceProperties.put("fetchSize", "1000");
        String table = path.getTable();
        if (table == null) {
            return;
        }
        sourceProperties.put("importQuery", this.getTableQuery(path.getDatabase(), schema, table));
        sinkProperties.put("tableName", table);
        sourceProperties.put("referenceName", ReferenceNames.cleanseReferenceName((String)table));
        sinkProperties.put("referenceName", ReferenceNames.cleanseReferenceName((String)table));
    }
}

