/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.cloudsql.postgres;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Metadata;
import io.cdap.cdap.api.annotation.MetadataProperty;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.api.plugin.PluginConfig;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import io.cdap.plugin.cloudsql.postgres.CloudSQLPostgreSQLConnectorConfig;
import io.cdap.plugin.common.ConfigUtil;
import io.cdap.plugin.db.SchemaReader;
import io.cdap.plugin.db.batch.config.AbstractDBSpecificSourceConfig;
import io.cdap.plugin.db.batch.source.AbstractDBSource;
import io.cdap.plugin.postgres.PostgresDBRecord;
import io.cdap.plugin.postgres.PostgresSchemaReader;
import io.cdap.plugin.util.CloudSQLUtil;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;

@Plugin(type="batchsource")
@Name(value="CloudSQLPostgreSQL")
@Description(value="Reads from a CloudSQL PostgreSQL database table(s) using a configurable SQL query. Outputs one record for each row returned by the query.")
@Metadata(properties={@MetadataProperty(key="connector", value="CloudSQLPostgreSQL")})
public class CloudSQLPostgreSQLSource
extends AbstractDBSource<CloudSQLPostgreSQLSourceConfig> {
    private final CloudSQLPostgreSQLSourceConfig cloudsqlPostgresqlSourceConfig;

    public CloudSQLPostgreSQLSource(CloudSQLPostgreSQLSourceConfig cloudsqlPostgresqlSourceConfig) {
        super((PluginConfig)cloudsqlPostgresqlSourceConfig);
        this.cloudsqlPostgresqlSourceConfig = cloudsqlPostgresqlSourceConfig;
    }

    public void configurePipeline(PipelineConfigurer pipelineConfigurer) {
        FailureCollector failureCollector = pipelineConfigurer.getStageConfigurer().getFailureCollector();
        if (!this.cloudsqlPostgresqlSourceConfig.containsMacro("instanceType") && !this.cloudsqlPostgresqlSourceConfig.containsMacro("connectionName")) {
            CloudSQLUtil.checkConnectionName((FailureCollector)failureCollector, (String)this.cloudsqlPostgresqlSourceConfig.connection.getInstanceType(), (String)this.cloudsqlPostgresqlSourceConfig.connection.getConnectionName());
        }
        super.configurePipeline(pipelineConfigurer);
    }

    protected SchemaReader getSchemaReader() {
        return new PostgresSchemaReader();
    }

    protected Class<? extends DBWritable> getDBRecordType() {
        return PostgresDBRecord.class;
    }

    protected String createConnectionString() {
        if ("private".equalsIgnoreCase(this.cloudsqlPostgresqlSourceConfig.connection.getInstanceType())) {
            return String.format("jdbc:postgresql://%s/%s", this.cloudsqlPostgresqlSourceConfig.connection.getConnectionName(), this.cloudsqlPostgresqlSourceConfig.connection.getDatabase());
        }
        return String.format("jdbc:postgresql:///%s?cloudSqlInstance=%s&socketFactory=com.google.cloud.sql.postgres.SocketFactory", this.cloudsqlPostgresqlSourceConfig.connection.getDatabase(), this.cloudsqlPostgresqlSourceConfig.connection.getConnectionName());
    }

    public static class CloudSQLPostgreSQLSourceConfig
    extends AbstractDBSpecificSourceConfig {
        @Name(value="useConnection")
        @Nullable
        @Description(value="Whether to use an existing connection.")
        private Boolean useConnection;
        @Name(value="connection")
        @Macro
        @Nullable
        @Description(value="The existing connection to use.")
        private CloudSQLPostgreSQLConnectorConfig connection;

        protected Map<String, String> getDBSpecificArguments() {
            return Collections.emptyMap();
        }

        public Integer getFetchSize() {
            Integer fetchSize = super.getFetchSize();
            return fetchSize == null ? Integer.parseInt("1000") : fetchSize;
        }

        protected CloudSQLPostgreSQLConnectorConfig getConnection() {
            return this.connection;
        }

        public void validate(FailureCollector collector) {
            ConfigUtil.validateConnection((PluginConfig)this, (Boolean)this.useConnection, (PluginConfig)this.connection, (FailureCollector)collector);
            super.validate(collector);
        }
    }
}

