/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.codetf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.codemodder.codetf.CodeTFChangesetEntry;
import io.codemodder.codetf.CodeTFReference;
import io.codemodder.codetf.CodeTFValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class CodeTFResult {
    private final String codemod;
    private final String summary;
    private final String description;
    private final Set<String> failedFiles;
    private final List<CodeTFReference> references;
    private final Map<String, String> properties;
    private final List<CodeTFChangesetEntry> changeset;

    @JsonCreator
    public CodeTFResult(@JsonProperty(value="codemod", index=1) String codemod, @JsonProperty(value="summary", index=2) String summary, @JsonProperty(value="description", index=3) String description, @JsonProperty(value="failedFiles", index=4) Set<String> failedFiles, @JsonProperty(value="references", index=5) List<CodeTFReference> references, @JsonProperty(value="properties", index=6) Map<String, String> properties, @JsonProperty(value="changeset", index=7) List<CodeTFChangesetEntry> changeset) {
        this.codemod = CodeTFValidator.requireNonBlank(codemod);
        this.summary = CodeTFValidator.requireNonBlank(summary);
        this.description = CodeTFValidator.requireNonBlank(description);
        this.failedFiles = CodeTFValidator.toImmutableCopyOrEmptyOnNull(failedFiles);
        this.references = CodeTFValidator.toImmutableCopyOrEmptyOnNull(references);
        this.properties = CodeTFValidator.toImmutableCopyOrEmptyOnNull(properties);
        this.changeset = Objects.requireNonNull(changeset);
    }

    public String getCodemod() {
        return this.codemod;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<String> getFailedFiles() {
        return this.failedFiles;
    }

    public List<CodeTFReference> getReferences() {
        return this.references;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public List<CodeTFChangesetEntry> getChangeset() {
        return this.changeset;
    }

    public static Builder basedOn(CodeTFResult result) {
        return new Builder(result);
    }

    public static class Builder {
        private final CodeTFResult originalResult;
        private String updatedSummary;
        private String updatedDescription;
        private List<CodeTFReference> updatedReferences;

        private Builder(CodeTFResult result) {
            this.originalResult = Objects.requireNonNull(result);
        }

        public Builder withSummary(String summary) {
            Objects.requireNonNull(summary);
            this.updatedSummary = summary;
            return this;
        }

        public Builder withDescription(String description) {
            Objects.requireNonNull(description);
            this.updatedDescription = description;
            return this;
        }

        public Builder withAdditionalReferences(List<CodeTFReference> references) {
            Objects.requireNonNull(references);
            if (this.updatedReferences == null) {
                this.updatedReferences = new ArrayList<CodeTFReference>(this.originalResult.references);
            }
            this.updatedReferences.addAll(references);
            return this;
        }

        public CodeTFResult build() {
            return new CodeTFResult(this.originalResult.getCodemod(), this.updatedSummary != null ? this.updatedSummary : this.originalResult.getSummary(), this.updatedDescription != null ? this.updatedDescription : this.originalResult.getDescription(), this.originalResult.getFailedFiles(), this.updatedReferences != null ? this.updatedReferences : this.originalResult.getReferences(), this.originalResult.getProperties(), this.originalResult.getChangeset());
        }
    }
}

