/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.definition.SupportedTypesProvider;
import io.rxmicro.annotation.processor.common.model.error.InternalErrorException;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.AnnotationProcessorEnvironment;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.data.model.Var;
import io.rxmicro.common.util.Formats;
import io.rxmicro.data.Pageable;
import io.rxmicro.data.RepeatParameter;
import io.rxmicro.data.sql.model.TransactionType;
import io.rxmicro.data.sql.operation.CustomSelect;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class MethodParamResolver {
    private static final Set<String> IGNORED_BY_TYPE = TransactionType.SUPPORTED_TRANSACTION_TYPES;
    private static final Set<Class<? extends Annotation>> IGNORED_BY_ANNOTATION_PRESENT = Set.of(CustomSelect.class);
    @Inject
    private SupportedTypesProvider supportedTypesProvider;

    public List<Var> getMethodParams(List<? extends VariableElement> parameters) {
        ArrayList<Var> vars = new ArrayList<Var>(parameters.size() + 1);
        StandardParameterHolder standardParameterHolder = new StandardParameterHolder();
        for (VariableElement variableElement : parameters) {
            if (this.isParameterShouldBeIgnored(variableElement)) continue;
            if (this.supportedTypesProvider.standardMethodParameters().contains(variableElement.asType())) {
                this.addStandardMethodParameters(vars, standardParameterHolder, variableElement);
                continue;
            }
            int repeatCount = Optional.ofNullable(variableElement.getAnnotation(RepeatParameter.class)).map(RepeatParameter::value).orElse(1);
            for (int i = 0; i < repeatCount; ++i) {
                Elements.asEnumElement((TypeMirror)variableElement.asType()).ifPresentOrElse(e -> {
                    if (Elements.isNotStandardEnum((TypeMirror)parameter.asType())) {
                        vars.add(new Var(parameter, Formats.format((String)"?.sql()", (Object[])new Object[]{parameter.getSimpleName()})));
                    } else {
                        vars.add(new Var(parameter, Formats.format((String)"?.name()", (Object[])new Object[]{parameter.getSimpleName()})));
                    }
                }, () -> vars.add(new Var(parameter)));
            }
        }
        return vars;
    }

    private boolean isParameterShouldBeIgnored(VariableElement parameter) {
        if (IGNORED_BY_TYPE.contains(AnnotationProcessorEnvironment.types().erasure(parameter.asType()).toString())) {
            return true;
        }
        return IGNORED_BY_ANNOTATION_PRESENT.stream().anyMatch(a -> parameter.getAnnotation(a) != null);
    }

    private void addStandardMethodParameters(List<Var> bindParams, StandardParameterHolder standardParameterHolder, VariableElement parameter) {
        if (!Pageable.class.getName().equals(parameter.asType().toString())) {
            throw new InternalErrorException("BindParameterResolver: standard method parameter not supported: ?", new Object[]{parameter.asType()});
        }
        this.addPageableParameter(bindParams, standardParameterHolder, parameter);
    }

    private void addPageableParameter(List<Var> bindParams, StandardParameterHolder standardParameterHolder, VariableElement parameter) {
        if (standardParameterHolder.page != null) {
            throw new InterruptProcessingException((Element)parameter, "Only one '?' parameter allowed per method", new Object[]{Pageable.class.getName()});
        }
        standardParameterHolder.page = parameter;
        String name = parameter.getSimpleName().toString();
        bindParams.add(new Var(parameter, Formats.format((String)"?.getLimit()", (Object[])new Object[]{name})));
        bindParams.add(new Var(parameter, Formats.format((String)"?.getOffset()", (Object[])new Object[]{name})));
    }

    private static final class StandardParameterHolder {
        private VariableElement page;

        private StandardParameterHolder() {
        }
    }
}

