/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Annotations;
import io.rxmicro.annotation.processor.data.sql.model.TableContext;
import io.rxmicro.common.util.Strings;
import io.rxmicro.data.sql.Schema;
import io.rxmicro.data.sql.Table;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@Singleton
public final class TableContextBuilder {
    public TableContext createTableContext(TypeElement modelTypeElement) {
        Table table = Optional.ofNullable(modelTypeElement.getAnnotation(Table.class)).orElseGet(() -> (Table)Annotations.defaultAnnotationInstance(Table.class));
        String className = modelTypeElement.getSimpleName().toString();
        List classNameWords = Strings.splitByCamelCase((String)className);
        String tableName = Optional.of(table.name()).filter(v -> !v.isEmpty()).orElseGet(() -> table.mappingStrategy().getModelName(classNameWords));
        Optional<String> schemaOptional = this.getSchema(table.schema(), modelTypeElement);
        if (schemaOptional.isPresent()) {
            if (tableName.contains(".")) {
                throw new InterruptProcessingException((Element)modelTypeElement, "Table name already contains a schema name. Remove the schema definition!", new Object[0]);
            }
            return new TableContext(schemaOptional.get(), tableName);
        }
        if (tableName.contains(".")) {
            String[] names = tableName.split("\\.");
            if (names.length != 2) {
                throw new InterruptProcessingException((Element)modelTypeElement, "Invalid table name: '?'. Set a valid name!", new Object[]{tableName});
            }
            return new TableContext(names[0], names[1]);
        }
        return new TableContext(tableName);
    }

    private Optional<String> getSchema(String tableSchema, TypeElement modelTypeElement) {
        Schema schemaAnnotation = modelTypeElement.getAnnotation(Schema.class);
        if (schemaAnnotation != null) {
            if (schemaAnnotation.value().isEmpty()) {
                throw new InterruptProcessingException((Element)modelTypeElement, "Redundant annotation: '?'. Remote it", new Object[]{Schema.class.getName()});
            }
            if (!tableSchema.isEmpty()) {
                throw new InterruptProcessingException((Element)modelTypeElement, "Redundant annotation: '?'. Remote it", new Object[]{Schema.class.getName()});
            }
            return Optional.of(schemaAnnotation.value());
        }
        return Optional.of(tableSchema).filter(v -> !v.isEmpty());
    }
}

