/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.model;

import io.rxmicro.common.util.Requires;
import java.util.List;

public final class SQLStatement {
    private final String originalSql;
    private final List<String> resultColumns;
    private final boolean defaultColumnOrder;
    private final String sqlExpression;
    private final List<String> bindParams;

    private SQLStatement(String originalSql, List<String> resultColumns, boolean defaultColumnOrder, String sqlExpression, List<String> bindParams) {
        this.originalSql = originalSql;
        this.resultColumns = (List)Requires.require(resultColumns);
        this.defaultColumnOrder = defaultColumnOrder;
        this.sqlExpression = (String)Requires.require((Object)sqlExpression);
        this.bindParams = (List)Requires.require(bindParams);
    }

    public boolean isDefaultColumnOrder() {
        return this.defaultColumnOrder;
    }

    public List<String> getResultColumns() {
        return this.resultColumns;
    }

    public String getOriginalSql() {
        return this.originalSql;
    }

    public String getSqlExpression() {
        return this.sqlExpression;
    }

    public List<String> getBindParams() {
        return this.bindParams;
    }

    public static final class Builder {
        private String originalSql;
        private List<String> resultColumns = List.of();
        private boolean defaultColumnOrder = true;
        private String sqlExpression;
        private List<String> bindParams = List.of();

        public Builder setOriginalSql(String originalSql) {
            this.originalSql = (String)Requires.require((Object)originalSql);
            return this;
        }

        public Builder setResultColumns(List<String> resultColumns) {
            this.resultColumns = (List)Requires.require(resultColumns);
            return this;
        }

        public Builder setDefaultColumnOrder(boolean defaultColumnOrder) {
            this.defaultColumnOrder = defaultColumnOrder;
            return this;
        }

        public Builder setSqlExpression(String sqlExpression) {
            this.sqlExpression = (String)Requires.require((Object)sqlExpression);
            return this;
        }

        public Builder setBindParams(List<String> bindParams) {
            this.bindParams = (List)Requires.require(bindParams);
            return this;
        }

        public SQLStatement build() {
            return new SQLStatement(this.originalSql, this.resultColumns, this.defaultColumnOrder, this.sqlExpression, this.bindParams);
        }
    }
}

