/*
 * Decompiled with CFR 0.152.
 */
package io.simplesource.api;

import io.simplesource.data.FutureResult;
import io.simplesource.data.NonEmptyList;
import io.simplesource.data.Sequence;
import java.time.Duration;
import java.util.UUID;

public interface CommandAPI<K, C> {
    public FutureResult<CommandError, UUID> publishCommand(Request<K, C> var1);

    public FutureResult<CommandError, NonEmptyList<Sequence>> queryCommandResult(UUID var1, Duration var2);

    default public FutureResult<CommandError, NonEmptyList<Sequence>> publishAndQueryCommand(Request<K, C> commandRequest, Duration timeout) {
        return this.publishCommand(commandRequest).flatMap(v -> this.queryCommandResult(((Request)commandRequest).commandId, timeout));
    }

    public static enum CommandError {
        InvalidCommand,
        InvalidReadSequence,
        CommandHandlerFailed,
        AggregateNotFound,
        Timeout,
        RemoteLookupFailed,
        CommandPublishError,
        InternalError,
        UnexpectedErrorCode;

    }

    public static final class Request<K, C> {
        private final K key;
        private final Sequence readSequence;
        private final UUID commandId;
        private final C command;

        public Request(K key, Sequence readSequence, UUID commandId, C command) {
            this.key = key;
            this.readSequence = readSequence;
            this.commandId = commandId;
            this.command = command;
        }

        public K key() {
            return this.key;
        }

        public Sequence readSequence() {
            return this.readSequence;
        }

        public UUID commandId() {
            return this.commandId;
        }

        public C command() {
            return this.command;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request other = (Request)o;
            K this$key = this.key();
            K other$key = other.key();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            Sequence this$readSequence = this.readSequence();
            Sequence other$readSequence = other.readSequence();
            if (this$readSequence == null ? other$readSequence != null : !this$readSequence.equals(other$readSequence)) {
                return false;
            }
            UUID this$commandId = this.commandId();
            UUID other$commandId = other.commandId();
            if (this$commandId == null ? other$commandId != null : !((Object)this$commandId).equals(other$commandId)) {
                return false;
            }
            C this$command = this.command();
            C other$command = other.command();
            return !(this$command == null ? other$command != null : !this$command.equals(other$command));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            K $key = this.key();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            Sequence $readSequence = this.readSequence();
            result = result * 59 + ($readSequence == null ? 43 : $readSequence.hashCode());
            UUID $commandId = this.commandId();
            result = result * 59 + ($commandId == null ? 43 : ((Object)$commandId).hashCode());
            C $command = this.command();
            result = result * 59 + ($command == null ? 43 : $command.hashCode());
            return result;
        }

        public String toString() {
            return "CommandAPI.Request(key=" + this.key() + ", readSequence=" + this.readSequence() + ", commandId=" + this.commandId() + ", command=" + this.command() + ")";
        }
    }
}

