/*
 * Decompiled with CFR 0.152.
 */
package io.simplesource.kafka.serialization.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.simplesource.api.CommandError;
import io.simplesource.data.NonEmptyList;
import io.simplesource.data.Result;
import io.simplesource.data.Sequence;
import io.simplesource.kafka.model.CommandRequest;
import io.simplesource.kafka.model.CommandResponse;
import io.simplesource.kafka.serialization.util.GenericMapper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.UUID;

class JsonSerdes<K, C> {
    protected final GenericMapper<K, JsonElement> keyMapper;
    protected final GenericMapper<C, JsonElement> commandMapper;

    public JsonSerdes(GenericMapper<K, JsonElement> keyMapper, GenericMapper<C, JsonElement> commandMapper) {
        this.keyMapper = keyMapper;
        this.commandMapper = commandMapper;
    }

    class CommandResponseAdapter
    implements JsonSerializer<CommandResponse>,
    JsonDeserializer<CommandResponse> {
        private static final String READ_SEQUENCE = "readSequence";
        private static final String COMMAND_ID = "commandId";
        private static final String RESULT = "result";
        private static final String REASON = "reason";
        private static final String ADDITIONAL_REASONS = "additionalReasons";
        private static final String ERROR_MESSAGE = "errorMessage";
        private static final String ERROR_CODE = "errorCode";
        private static final String WRITE_SEQUENCE = "writeSequence";

        CommandResponseAdapter() {
        }

        public JsonElement serialize(CommandResponse commandResponse, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject wrapper = new JsonObject();
            wrapper.addProperty(READ_SEQUENCE, (Number)commandResponse.readSequence().getSeq());
            wrapper.addProperty(COMMAND_ID, commandResponse.commandId().toString());
            wrapper.add(RESULT, (JsonElement)commandResponse.sequenceResult().fold(reasons -> {
                JsonObject failureWrapper = new JsonObject();
                failureWrapper.add(REASON, this.serializeReason((CommandError)reasons.head()));
                JsonArray additionalReasons = new JsonArray();
                reasons.tail().forEach(reason -> additionalReasons.add(this.serializeReason((CommandError)reason)));
                failureWrapper.add(ADDITIONAL_REASONS, (JsonElement)additionalReasons);
                return failureWrapper;
            }, sequence -> {
                JsonObject successWrapper = new JsonObject();
                successWrapper.addProperty(WRITE_SEQUENCE, (Number)sequence.getSeq());
                return successWrapper;
            }));
            return wrapper;
        }

        private JsonElement serializeReason(CommandError commandError) {
            JsonObject wrapper = new JsonObject();
            wrapper.addProperty(ERROR_MESSAGE, commandError.getMessage());
            wrapper.addProperty(ERROR_CODE, commandError.getReason().name());
            return wrapper;
        }

        public CommandResponse deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            Result result;
            JsonObject wrapper = jsonElement.getAsJsonObject();
            Sequence readSequence = Sequence.position((long)wrapper.getAsJsonPrimitive(READ_SEQUENCE).getAsLong());
            UUID commandId = UUID.fromString(wrapper.getAsJsonPrimitive(COMMAND_ID).getAsString());
            JsonObject resultWrapper = wrapper.getAsJsonObject(RESULT);
            if (resultWrapper.has(REASON)) {
                CommandError headCommandError = this.deserializeReason(resultWrapper.getAsJsonObject(REASON));
                ArrayList tailCommandErrors = new ArrayList();
                resultWrapper.getAsJsonArray(ADDITIONAL_REASONS).forEach(reason -> tailCommandErrors.add(this.deserializeReason(reason.getAsJsonObject())));
                result = Result.failure((NonEmptyList)new NonEmptyList((Object)headCommandError, tailCommandErrors));
            } else {
                result = Result.success((Object)Sequence.position((long)resultWrapper.getAsJsonPrimitive(WRITE_SEQUENCE).getAsLong()));
            }
            return new CommandResponse(commandId, readSequence, result);
        }

        private CommandError deserializeReason(JsonObject element) {
            return CommandError.of((CommandError.Reason)CommandError.Reason.valueOf((String)element.getAsJsonPrimitive(ERROR_CODE).getAsString()), (String)element.getAsJsonPrimitive(ERROR_MESSAGE).getAsString());
        }
    }

    class UUIDAdapter
    implements JsonSerializer<UUID>,
    JsonDeserializer<UUID> {
        private static final String COMMAND_ID = "commandId";

        UUIDAdapter() {
        }

        public JsonElement serialize(UUID uuid, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject wrapper = new JsonObject();
            wrapper.addProperty(COMMAND_ID, uuid.toString());
            return wrapper;
        }

        public UUID deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject wrapper = jsonElement.getAsJsonObject();
            return UUID.fromString(wrapper.getAsJsonPrimitive(COMMAND_ID).getAsString());
        }
    }

    class CommandRequestAdapter
    implements JsonSerializer<CommandRequest<K, C>>,
    JsonDeserializer<CommandRequest<K, C>> {
        private static final String AGGREGATE_KEY = "key";
        private static final String READ_SEQUENCE = "readSequence";
        private static final String COMMAND_ID = "commandId";
        private static final String COMMAND = "command";

        CommandRequestAdapter() {
        }

        public JsonElement serialize(CommandRequest<K, C> commandRequest, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject wrapper = new JsonObject();
            wrapper.add(AGGREGATE_KEY, JsonSerdes.this.keyMapper.toGeneric(commandRequest.aggregateKey()));
            wrapper.addProperty(READ_SEQUENCE, (Number)commandRequest.readSequence().getSeq());
            wrapper.addProperty(COMMAND_ID, commandRequest.commandId().toString());
            wrapper.add(COMMAND, JsonSerdes.this.commandMapper.toGeneric(commandRequest.command()));
            return wrapper;
        }

        public CommandRequest<K, C> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject wrapper = jsonElement.getAsJsonObject();
            return new CommandRequest(JsonSerdes.this.keyMapper.fromGeneric(wrapper.get(AGGREGATE_KEY)), JsonSerdes.this.commandMapper.fromGeneric(wrapper.get(COMMAND)), Sequence.position((long)wrapper.getAsJsonPrimitive(READ_SEQUENCE).getAsLong()), UUID.fromString(wrapper.getAsJsonPrimitive(COMMAND_ID).getAsString()));
        }
    }
}

