/*
 * Decompiled with CFR 0.152.
 */
package io.simplesource.kafka.serialization.avro;

import io.simplesource.kafka.api.CommandSerdes;
import io.simplesource.kafka.model.CommandRequest;
import io.simplesource.kafka.model.CommandResponse;
import io.simplesource.kafka.serialization.avro.AvroGenericUtils;
import io.simplesource.kafka.serialization.avro.AvroSerdes;
import io.simplesource.kafka.serialization.avro.AvroSpecificGenericMapper;
import io.simplesource.kafka.serialization.util.GenericMapper;
import io.simplesource.kafka.serialization.util.GenericSerde;
import java.util.Arrays;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.common.serialization.Serde;

public final class AvroCommandSerdes<K, C>
implements CommandSerdes<K, C> {
    private final Serde<K> ak;
    private final Serde<CommandRequest<K, C>> crq;
    private final Serde<UUID> crk;
    private final Serde<CommandResponse> crp;

    public static <K extends GenericRecord, C extends GenericRecord> AvroCommandSerdes<K, C> of(String schemaRegistryUrl) {
        return AvroCommandSerdes.of(schemaRegistryUrl, false);
    }

    public static <K extends GenericRecord, C extends GenericRecord> AvroCommandSerdes<K, C> of(String schemaRegistryUrl, boolean useMockSchemaRegistry) {
        return new AvroCommandSerdes(AvroSpecificGenericMapper.specificDomainMapper(), AvroSpecificGenericMapper.specificDomainMapper(), schemaRegistryUrl, useMockSchemaRegistry);
    }

    public static <K, C> AvroCommandSerdes<K, C> of(GenericMapper<K, GenericRecord> keyMapper, GenericMapper<C, GenericRecord> commandMapper, String schemaRegistryUrl, boolean useMockSchemaRegistry) {
        return new AvroCommandSerdes<K, C>(keyMapper, commandMapper, schemaRegistryUrl, useMockSchemaRegistry);
    }

    public AvroCommandSerdes(GenericMapper<K, GenericRecord> keyMapper, GenericMapper<C, GenericRecord> commandMapper, String schemaRegistryUrl, boolean useMockSchemaRegistry) {
        Serde<GenericRecord> keySerde = AvroGenericUtils.genericAvroSerde(schemaRegistryUrl, useMockSchemaRegistry, true);
        Serde<GenericRecord> valueSerde = AvroGenericUtils.genericAvroSerde(schemaRegistryUrl, useMockSchemaRegistry, false);
        this.ak = GenericSerde.of(keySerde, keyMapper::toGeneric, keyMapper::fromGeneric);
        this.crq = GenericSerde.of(valueSerde, v -> AvroSerdes.CommandRequestAvroHelper.toGenericRecord((CommandRequest<GenericRecord, GenericRecord>)v.map2(keyMapper::toGeneric, commandMapper::toGeneric)), s -> AvroSerdes.CommandRequestAvroHelper.fromGenericRecord(s).map2(keyMapper::fromGeneric, x -> commandMapper.fromGeneric((GenericRecord)x)));
        this.crk = GenericSerde.of(valueSerde, AvroSerdes.CommandResponseKeyAvroHelper::toGenericRecord, AvroSerdes.CommandResponseKeyAvroHelper::fromGenericRecord);
        this.crp = GenericSerde.of(valueSerde, AvroSerdes.CommandResponseAvroHelper::toCommandResponse, AvroSerdes.CommandResponseAvroHelper::fromCommandResponse);
    }

    public Serde<K> aggregateKey() {
        return this.ak;
    }

    public Serde<CommandRequest<K, C>> commandRequest() {
        return this.crq;
    }

    public Serde<UUID> commandResponseKey() {
        return this.crk;
    }

    public Serde<CommandResponse> commandResponse() {
        return this.crp;
    }

    private static Schema toNullableSchema(Schema schema) {
        return Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), schema));
    }
}

