/*
 * Decompiled with CFR 0.152.
 */
package io.simplesource.kafka.serialization.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import io.simplesource.api.CommandError;
import io.simplesource.data.NonEmptyList;
import io.simplesource.data.Result;
import io.simplesource.data.Sequence;
import io.simplesource.kafka.api.AggregateSerdes;
import io.simplesource.kafka.model.AggregateUpdate;
import io.simplesource.kafka.model.CommandRequest;
import io.simplesource.kafka.model.CommandResponse;
import io.simplesource.kafka.model.ValueWithSequence;
import io.simplesource.kafka.serialization.json.JsonGenericMapper;
import io.simplesource.kafka.serialization.json.JsonSerdes;
import io.simplesource.kafka.serialization.util.GenericMapper;
import io.simplesource.kafka.serialization.util.GenericSerde;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;

public final class JsonAggregateSerdes<K, C, E, A>
extends JsonSerdes<K, C>
implements AggregateSerdes<K, C, E, A> {
    private final GenericMapper<A, JsonElement> aggregateMapper;
    private final GenericMapper<E, JsonElement> eventMapper;
    private final Serde<String> serde;
    private final Gson gson;
    private final JsonParser parser;
    private final Serde<K> ak;
    private final Serde<CommandRequest<K, C>> cr;
    private final Serde<UUID> crk;
    private final Serde<ValueWithSequence<E>> vws;
    private final Serde<AggregateUpdate<A>> au;
    private final Serde<CommandResponse> cr2;

    public JsonAggregateSerdes() {
        this(JsonGenericMapper.jsonDomainMapper(), JsonGenericMapper.jsonDomainMapper(), JsonGenericMapper.jsonDomainMapper(), JsonGenericMapper.jsonDomainMapper());
    }

    public JsonAggregateSerdes(GenericMapper<K, JsonElement> keyMapper, GenericMapper<C, JsonElement> commandMapper, GenericMapper<E, JsonElement> eventMapper, GenericMapper<A, JsonElement> aggregateMapper) {
        super(keyMapper, commandMapper);
        this.aggregateMapper = aggregateMapper;
        this.eventMapper = eventMapper;
        this.serde = Serdes.String();
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(CommandRequest.class, (Object)new CommandRequestAdapter());
        gsonBuilder.registerTypeAdapter(UUID.class, (Object)new UUIDAdapter());
        gsonBuilder.registerTypeAdapter(ValueWithSequence.class, (Object)new ValueWithSequenceAdapter());
        gsonBuilder.registerTypeAdapter(AggregateUpdate.class, (Object)new AggregateUpdateAdapter());
        gsonBuilder.registerTypeAdapter(CommandResponse.class, (Object)new CommandResponseAdapter());
        this.gson = gsonBuilder.create();
        this.parser = new JsonParser();
        this.ak = GenericSerde.of(this.serde, k -> ((JsonElement)keyMapper.toGeneric(k)).toString(), s -> keyMapper.fromGeneric(this.parser.parse(s)));
        this.cr = GenericSerde.of(this.serde, arg_0 -> ((Gson)this.gson).toJson(arg_0), s -> (CommandRequest)this.gson.fromJson(s, new TypeToken<CommandRequest<K, C>>(){}.getType()));
        this.crk = GenericSerde.of(this.serde, arg_0 -> ((Gson)this.gson).toJson(arg_0), s -> (UUID)this.gson.fromJson(s, new TypeToken<UUID>(){}.getType()));
        this.vws = GenericSerde.of(this.serde, arg_0 -> ((Gson)this.gson).toJson(arg_0), s -> (ValueWithSequence)this.gson.fromJson(s, new TypeToken<ValueWithSequence<E>>(){}.getType()));
        this.au = GenericSerde.of(this.serde, arg_0 -> ((Gson)this.gson).toJson(arg_0), s -> (AggregateUpdate)this.gson.fromJson(s, new TypeToken<AggregateUpdate<A>>(){}.getType()));
        this.cr2 = GenericSerde.of(this.serde, arg_0 -> ((Gson)this.gson).toJson(arg_0), s -> (CommandResponse)this.gson.fromJson(s, new TypeToken<CommandResponse>(){}.getType()));
    }

    public Serde<K> aggregateKey() {
        return this.ak;
    }

    public Serde<CommandRequest<K, C>> commandRequest() {
        return this.cr;
    }

    public Serde<UUID> commandResponseKey() {
        return this.crk;
    }

    public Serde<ValueWithSequence<E>> valueWithSequence() {
        return this.vws;
    }

    public Serde<AggregateUpdate<A>> aggregateUpdate() {
        return this.au;
    }

    public Serde<CommandResponse> commandResponse() {
        return this.cr2;
    }

    private class CommandResponseAdapter
    implements JsonSerializer<CommandResponse>,
    JsonDeserializer<CommandResponse> {
        private static final String READ_SEQUENCE = "readSequence";
        private static final String COMMAND_ID = "commandId";
        private static final String RESULT = "result";
        private static final String REASON = "reason";
        private static final String ADDITIONAL_REASONS = "additionalReasons";
        private static final String ERROR_MESSAGE = "errorMessage";
        private static final String ERROR_CODE = "errorCode";
        private static final String WRITE_SEQUENCE = "writeSequence";

        private CommandResponseAdapter() {
        }

        public JsonElement serialize(CommandResponse commandResponse, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject wrapper = new JsonObject();
            wrapper.addProperty(READ_SEQUENCE, (Number)commandResponse.readSequence().getSeq());
            wrapper.addProperty(COMMAND_ID, commandResponse.commandId().toString());
            wrapper.add(RESULT, (JsonElement)commandResponse.sequenceResult().fold(reasons -> {
                JsonObject failureWrapper = new JsonObject();
                failureWrapper.add(REASON, this.serializeReason((CommandError)reasons.head()));
                JsonArray additionalReasons = new JsonArray();
                reasons.tail().forEach(reason -> additionalReasons.add(this.serializeReason((CommandError)reason)));
                failureWrapper.add(ADDITIONAL_REASONS, (JsonElement)additionalReasons);
                return failureWrapper;
            }, sequence -> {
                JsonObject successWrapper = new JsonObject();
                successWrapper.addProperty(WRITE_SEQUENCE, (Number)sequence.getSeq());
                return successWrapper;
            }));
            return wrapper;
        }

        private JsonElement serializeReason(CommandError commandError) {
            JsonObject wrapper = new JsonObject();
            wrapper.addProperty(ERROR_MESSAGE, commandError.getMessage());
            wrapper.addProperty(ERROR_CODE, commandError.getReason().name());
            return wrapper;
        }

        public CommandResponse deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            Result result;
            JsonObject wrapper = jsonElement.getAsJsonObject();
            Sequence readSequence = Sequence.position((long)wrapper.getAsJsonPrimitive(READ_SEQUENCE).getAsLong());
            UUID commandId = UUID.fromString(wrapper.getAsJsonPrimitive(COMMAND_ID).getAsString());
            JsonObject resultWrapper = wrapper.getAsJsonObject(RESULT);
            if (resultWrapper.has(REASON)) {
                CommandError headCommandError = this.deserializeReason(resultWrapper.getAsJsonObject(REASON));
                ArrayList tailCommandErrors = new ArrayList();
                resultWrapper.getAsJsonArray(ADDITIONAL_REASONS).forEach(reason -> tailCommandErrors.add(this.deserializeReason(reason.getAsJsonObject())));
                result = Result.failure((NonEmptyList)new NonEmptyList((Object)headCommandError, tailCommandErrors));
            } else {
                result = Result.success((Object)Sequence.position((long)resultWrapper.getAsJsonPrimitive(WRITE_SEQUENCE).getAsLong()));
            }
            return new CommandResponse(commandId, readSequence, result);
        }

        private CommandError deserializeReason(JsonObject element) {
            return CommandError.of((CommandError.Reason)CommandError.Reason.valueOf((String)element.getAsJsonPrimitive(ERROR_CODE).getAsString()), (String)element.getAsJsonPrimitive(ERROR_MESSAGE).getAsString());
        }
    }

    private class AggregateUpdateAdapter
    implements JsonSerializer<AggregateUpdate<A>>,
    JsonDeserializer<AggregateUpdate<A>> {
        private static final String AGGREGATION = "aggregate_update";
        private static final String SEQUENCE = "sequence";

        private AggregateUpdateAdapter() {
        }

        public JsonElement serialize(AggregateUpdate<A> aggregateUpdate, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject wrapper = new JsonObject();
            wrapper.add(AGGREGATION, (JsonElement)JsonAggregateSerdes.this.aggregateMapper.toGeneric(aggregateUpdate.aggregate()));
            wrapper.addProperty(SEQUENCE, (Number)aggregateUpdate.sequence().getSeq());
            return wrapper;
        }

        public AggregateUpdate<A> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject wrapper = jsonElement.getAsJsonObject();
            return new AggregateUpdate(JsonAggregateSerdes.this.aggregateMapper.fromGeneric(wrapper.get(AGGREGATION)), Sequence.position((long)wrapper.getAsJsonPrimitive(SEQUENCE).getAsLong()));
        }
    }

    private class ValueWithSequenceAdapter
    implements JsonSerializer<ValueWithSequence<E>>,
    JsonDeserializer<ValueWithSequence<E>> {
        private static final String VALUE = "value";
        private static final String SEQUENCE = "sequence";

        private ValueWithSequenceAdapter() {
        }

        public JsonElement serialize(ValueWithSequence<E> valueWithSequence, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject wrapper = new JsonObject();
            wrapper.add(VALUE, (JsonElement)JsonAggregateSerdes.this.eventMapper.toGeneric(valueWithSequence.value()));
            wrapper.addProperty(SEQUENCE, (Number)valueWithSequence.sequence().getSeq());
            return wrapper;
        }

        public ValueWithSequence<E> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject wrapper = jsonElement.getAsJsonObject();
            return new ValueWithSequence(JsonAggregateSerdes.this.eventMapper.fromGeneric(wrapper.get(VALUE)), Sequence.position((long)wrapper.getAsJsonPrimitive(SEQUENCE).getAsLong()));
        }
    }

    private class UUIDAdapter
    implements JsonSerializer<UUID>,
    JsonDeserializer<UUID> {
        private static final String COMMAND_ID = "commandId";

        private UUIDAdapter() {
        }

        public JsonElement serialize(UUID uuid, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject wrapper = new JsonObject();
            wrapper.addProperty(COMMAND_ID, uuid.toString());
            return wrapper;
        }

        public UUID deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject wrapper = jsonElement.getAsJsonObject();
            return UUID.fromString(wrapper.getAsJsonPrimitive(COMMAND_ID).getAsString());
        }
    }

    private class CommandRequestAdapter
    implements JsonSerializer<CommandRequest<K, C>>,
    JsonDeserializer<CommandRequest<K, C>> {
        private static final String AGGREGATE_KEY = "key";
        private static final String READ_SEQUENCE = "readSequence";
        private static final String COMMAND_ID = "commandId";
        private static final String COMMAND = "command";

        private CommandRequestAdapter() {
        }

        public JsonElement serialize(CommandRequest<K, C> commandRequest, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject wrapper = new JsonObject();
            wrapper.add(AGGREGATE_KEY, (JsonElement)JsonAggregateSerdes.this.keyMapper.toGeneric(commandRequest.aggregateKey()));
            wrapper.addProperty(READ_SEQUENCE, (Number)commandRequest.readSequence().getSeq());
            wrapper.addProperty(COMMAND_ID, commandRequest.commandId().toString());
            wrapper.add(COMMAND, (JsonElement)JsonAggregateSerdes.this.commandMapper.toGeneric(commandRequest.command()));
            return wrapper;
        }

        public CommandRequest<K, C> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject wrapper = jsonElement.getAsJsonObject();
            return new CommandRequest(JsonAggregateSerdes.this.keyMapper.fromGeneric(wrapper.get(AGGREGATE_KEY)), JsonAggregateSerdes.this.commandMapper.fromGeneric(wrapper.get(COMMAND)), Sequence.position((long)wrapper.getAsJsonPrimitive(READ_SEQUENCE).getAsLong()), UUID.fromString(wrapper.getAsJsonPrimitive(COMMAND_ID).getAsString()));
        }
    }
}

