/*
 * Decompiled with CFR 0.152.
 */
package io.simplesource.kafka.serialization.avro;

import io.simplesource.kafka.api.AggregateSerdes;
import io.simplesource.kafka.model.AggregateUpdate;
import io.simplesource.kafka.model.CommandRequest;
import io.simplesource.kafka.model.CommandResponse;
import io.simplesource.kafka.model.ValueWithSequence;
import io.simplesource.kafka.serialization.avro.AvroGenericUtils;
import io.simplesource.kafka.serialization.avro.AvroSerdes;
import io.simplesource.kafka.serialization.avro.AvroSpecificGenericMapper;
import io.simplesource.kafka.serialization.util.GenericMapper;
import io.simplesource.kafka.serialization.util.GenericSerde;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.common.serialization.Serde;

public final class AvroAggregateSerdes<K, C, E, A>
implements AggregateSerdes<K, C, E, A> {
    private final Serde<K> ak;
    private final Serde<CommandRequest<K, C>> crq;
    private final Serde<UUID> crk;
    private final Serde<ValueWithSequence<E>> vws;
    private final Serde<AggregateUpdate<A>> au;
    private final Serde<CommandResponse<K>> crp;

    public static <K extends GenericRecord, C extends GenericRecord, E extends GenericRecord, A extends GenericRecord> AvroAggregateSerdes<K, C, E, A> of(String schemaRegistryUrl, Schema aggregateSchema) {
        return AvroAggregateSerdes.of(schemaRegistryUrl, false, aggregateSchema);
    }

    public static <K extends GenericRecord, C extends GenericRecord, E extends GenericRecord, A extends GenericRecord> AvroAggregateSerdes<K, C, E, A> of(String schemaRegistryUrl, boolean useMockSchemaRegistry, Schema aggregateSchema) {
        return new AvroAggregateSerdes(AvroSpecificGenericMapper.specificDomainMapper(), AvroSpecificGenericMapper.specificDomainMapper(), AvroSpecificGenericMapper.specificDomainMapper(), AvroSpecificGenericMapper.specificDomainMapper(), schemaRegistryUrl, useMockSchemaRegistry, aggregateSchema);
    }

    public AvroAggregateSerdes(GenericMapper<K, GenericRecord> keyMapper, GenericMapper<C, GenericRecord> commandMapper, GenericMapper<E, GenericRecord> eventMapper, GenericMapper<A, GenericRecord> aggregateMapper, String schemaRegistryUrl, boolean useMockSchemaRegistry, Schema aggregateSchema) {
        Serde<GenericRecord> aggKeySerde = AvroGenericUtils.genericAvroSerde(schemaRegistryUrl, useMockSchemaRegistry, true, AvroGenericUtils.SchemaNameStrategy.TOPIC_NAME);
        Serde<GenericRecord> aggValueSerde = AvroGenericUtils.genericAvroSerde(schemaRegistryUrl, useMockSchemaRegistry, false, AvroGenericUtils.SchemaNameStrategy.TOPIC_NAME);
        Serde<GenericRecord> valueSerde = AvroGenericUtils.genericAvroSerde(schemaRegistryUrl, useMockSchemaRegistry, false, AvroGenericUtils.SchemaNameStrategy.TOPIC_RECORD_NAME);
        this.ak = GenericSerde.of(aggKeySerde, keyMapper::toGeneric, keyMapper::fromGeneric);
        this.crq = GenericSerde.of(valueSerde, v -> AvroSerdes.CommandRequestAvroHelper.toGenericRecord((CommandRequest<GenericRecord, GenericRecord>)v.map2(keyMapper::toGeneric, commandMapper::toGeneric)), (S s) -> AvroSerdes.CommandRequestAvroHelper.fromGenericRecord(s).map2(keyMapper::fromGeneric, commandMapper::fromGeneric));
        this.crk = GenericSerde.of(valueSerde, AvroSerdes.CommandResponseKeyAvroHelper::toGenericRecord, AvroSerdes.CommandResponseKeyAvroHelper::fromGenericRecord);
        this.vws = GenericSerde.of(valueSerde, v -> AvroGenericUtils.ValueWithSequenceAvroHelper.toGenericRecord((ValueWithSequence<GenericRecord>)v.map(eventMapper::toGeneric)), (S s) -> AvroGenericUtils.ValueWithSequenceAvroHelper.fromGenericRecord(s).map(eventMapper::fromGeneric));
        this.au = GenericSerde.of(aggValueSerde, v -> AvroSerdes.AggregateUpdateAvroHelper.toGenericRecord((AggregateUpdate<GenericRecord>)v.map(aggregateMapper::toGeneric), aggregateSchema), (S s) -> AvroSerdes.AggregateUpdateAvroHelper.fromGenericRecord(s).map(aggregateMapper::fromGeneric));
        this.crp = GenericSerde.of(valueSerde, v -> AvroSerdes.CommandResponseAvroHelper.toCommandResponse((CommandResponse<GenericRecord>)v.map(keyMapper::toGeneric)), (S s) -> AvroSerdes.CommandResponseAvroHelper.fromCommandResponse(s).map(keyMapper::fromGeneric));
    }

    public Serde<K> aggregateKey() {
        return this.ak;
    }

    public Serde<CommandRequest<K, C>> commandRequest() {
        return this.crq;
    }

    public Serde<UUID> commandResponseKey() {
        return this.crk;
    }

    public Serde<ValueWithSequence<E>> valueWithSequence() {
        return this.vws;
    }

    public Serde<AggregateUpdate<A>> aggregateUpdate() {
        return this.au;
    }

    public Serde<CommandResponse<K>> commandResponse() {
        return this.crp;
    }
}

