/*
 * Decompiled with CFR 0.152.
 */
package io.simplesource.kafka.serialization.avro;

import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.subject.TopicRecordNameStrategy;
import io.confluent.kafka.streams.serdes.avro.GenericAvroSerde;
import io.simplesource.data.Sequence;
import io.simplesource.kafka.model.ValueWithSequence;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.kafka.common.serialization.Serde;

public final class AvroGenericUtils {
    public static Serde<GenericRecord> genericAvroSerde(String schemaRegistryUrl, boolean useMockSchemaRegistry, boolean isKey) {
        return AvroGenericUtils.genericAvroSerde(schemaRegistryUrl, useMockSchemaRegistry, isKey, SchemaNameStrategy.TOPIC_RECORD_NAME);
    }

    public static Serde<GenericRecord> genericAvroSerde(String schemaRegistryUrl, boolean useMockSchemaRegistry, boolean isKey, SchemaNameStrategy schemaNameStrategy) {
        Map<String, Object> configMap = AvroGenericUtils.avroSchemaRegistryConfig(schemaRegistryUrl, schemaNameStrategy);
        GenericAvroSerde serde = useMockSchemaRegistry ? new GenericAvroSerde((SchemaRegistryClient)new MockSchemaRegistryClient()) : new GenericAvroSerde();
        serde.configure(configMap, isKey);
        return serde;
    }

    private static Map<String, Object> avroSchemaRegistryConfig(String schemaRegistryUrl, SchemaNameStrategy schemaNameStrategy) {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("schema.registry.url", schemaRegistryUrl);
        if (schemaNameStrategy == SchemaNameStrategy.TOPIC_RECORD_NAME) {
            configMap.put("key.subject.name.strategy", TopicRecordNameStrategy.class);
            configMap.put("value.subject.name.strategy", TopicRecordNameStrategy.class);
        }
        return configMap;
    }

    public static class ValueWithSequenceAvroHelper {
        private static final Map<Schema, Schema> schemaCache = new ConcurrentHashMap<Schema, Schema>();
        private static final String VALUE = "value";
        private static final String SEQUENCE = "sequence";

        public static GenericRecord toGenericRecord(ValueWithSequence<GenericRecord> valueWithSequence) {
            GenericRecord value = (GenericRecord)valueWithSequence.value();
            Schema schema = schemaCache.computeIfAbsent(value.getSchema(), k -> ValueWithSequenceAvroHelper.valueWithSequenceSchema(value));
            GenericRecordBuilder builder = new GenericRecordBuilder(schema);
            return builder.set(VALUE, (Object)value).set(SEQUENCE, (Object)valueWithSequence.sequence().getSeq()).build();
        }

        public static ValueWithSequence<GenericRecord> fromGenericRecord(GenericRecord record) {
            GenericRecord genericValue = (GenericRecord)record.get(VALUE);
            Sequence sequence = Sequence.position((long)((Long)record.get(SEQUENCE)));
            return new ValueWithSequence((Object)genericValue, sequence);
        }

        private static Schema valueWithSequenceSchema(GenericRecord value) {
            return (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)(value.getSchema().getName() + "ValueWithSequence")).namespace(value.getClass().getPackage().getName())).fields().name(VALUE).type(value.getSchema()).noDefault().name(SEQUENCE).type().longType().noDefault().endRecord();
        }
    }

    public static enum SchemaNameStrategy {
        TOPIC_NAME,
        TOPIC_RECORD_NAME;

    }
}

