/*
 * Decompiled with CFR 0.152.
 */
package io.simplesource.kafka.testutils;

import io.simplesource.kafka.internal.client.ResponseSubscription;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.TopologyTestDriver;

final class TestTopologyReceiver<K, V>
implements ResponseSubscription {
    Supplier<Integer> getDriverOutput = () -> {
        ProducerRecord record;
        int count = 0;
        while ((record = driver.readOutput(spec.topicName, Serdes.String().deserializer(), spec.valueSerde.deserializer())) != null) {
            ++count;
            Object key = spec.keyConverter.apply(record.key());
            updateTarget.accept(key, record.value());
        }
        return count;
    };

    TestTopologyReceiver(BiConsumer<K, V> updateTarget, TopologyTestDriver driver, ReceiverSpec<K, V> spec) {
    }

    void pollForState() {
        this.getDriverOutput.get();
    }

    public void close() {
    }

    static final class ReceiverSpec<K, V> {
        private final String topicName;
        private final int delayMillis;
        private final int pollAttempts;
        private final Serde<V> valueSerde;
        private final Function<String, K> keyConverter;

        public ReceiverSpec(String topicName, int delayMillis, int pollAttempts, Serde<V> valueSerde, Function<String, K> keyConverter) {
            this.topicName = topicName;
            this.delayMillis = delayMillis;
            this.pollAttempts = pollAttempts;
            this.valueSerde = valueSerde;
            this.keyConverter = keyConverter;
        }

        public String topicName() {
            return this.topicName;
        }

        public int delayMillis() {
            return this.delayMillis;
        }

        public int pollAttempts() {
            return this.pollAttempts;
        }

        public Serde<V> valueSerde() {
            return this.valueSerde;
        }

        public Function<String, K> keyConverter() {
            return this.keyConverter;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReceiverSpec)) {
                return false;
            }
            ReceiverSpec other = (ReceiverSpec)o;
            String this$topicName = this.topicName();
            String other$topicName = other.topicName();
            if (this$topicName == null ? other$topicName != null : !this$topicName.equals(other$topicName)) {
                return false;
            }
            if (this.delayMillis() != other.delayMillis()) {
                return false;
            }
            if (this.pollAttempts() != other.pollAttempts()) {
                return false;
            }
            Serde<V> this$valueSerde = this.valueSerde();
            Serde<V> other$valueSerde = other.valueSerde();
            if (this$valueSerde == null ? other$valueSerde != null : !this$valueSerde.equals(other$valueSerde)) {
                return false;
            }
            Function<String, K> this$keyConverter = this.keyConverter();
            Function<String, K> other$keyConverter = other.keyConverter();
            return !(this$keyConverter == null ? other$keyConverter != null : !this$keyConverter.equals(other$keyConverter));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $topicName = this.topicName();
            result = result * 59 + ($topicName == null ? 43 : $topicName.hashCode());
            result = result * 59 + this.delayMillis();
            result = result * 59 + this.pollAttempts();
            Serde<V> $valueSerde = this.valueSerde();
            result = result * 59 + ($valueSerde == null ? 43 : $valueSerde.hashCode());
            Function<String, K> $keyConverter = this.keyConverter();
            result = result * 59 + ($keyConverter == null ? 43 : $keyConverter.hashCode());
            return result;
        }

        public String toString() {
            return "TestTopologyReceiver.ReceiverSpec(topicName=" + this.topicName() + ", delayMillis=" + this.delayMillis() + ", pollAttempts=" + this.pollAttempts() + ", valueSerde=" + this.valueSerde() + ", keyConverter=" + this.keyConverter() + ")";
        }
    }
}

