/*
 * Decompiled with CFR 0.152.
 */
package com.ms.tools.api.tencent.sms.response;

import com.alibaba.fastjson2.annotation.JSONField;
import com.ms.tools.api.tencent.sms.response.ErrorRB;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SignatureValidationSmsResponse {
    private Boolean status;
    @JSONField(name="RequestId")
    private String requestId;
    @JSONField(name="DescribeSignListStatusSet")
    private List<DescribeSignListStatusSetRB> describeSignListStatusSet;
    @JSONField(name="Error")
    private ErrorRB error;
    private Map<Integer, DescribeSignListStatusSetRB> describeSignListStatus;

    public SignatureValidationSmsResponse() {
        this.status = true;
    }

    public SignatureValidationSmsResponse(Boolean status, String requestId, List<DescribeSignListStatusSetRB> describeSignListStatusSet, ErrorRB error, Map<Integer, DescribeSignListStatusSetRB> describeSignListStatus) {
        this.status = status;
        this.requestId = requestId;
        this.describeSignListStatusSet = describeSignListStatusSet;
        this.error = error;
        this.describeSignListStatus = describeSignListStatus;
    }

    public static SignatureValidationSmsResponse errorResponse() {
        SignatureValidationSmsResponse response = new SignatureValidationSmsResponse();
        response.setStatus(false);
        response.setError(ErrorRB.error());
        return response;
    }

    public void finishing() {
        if (this.error != null) {
            this.status = false;
        } else if (this.describeSignListStatusSet.isEmpty()) {
            this.status = false;
            this.error = new ErrorRB();
            this.error.setCode("Data is empty");
            this.error.setMessage("Template data not queried");
        } else {
            this.describeSignListStatus = new HashMap<Integer, DescribeSignListStatusSetRB>(this.describeSignListStatusSet.size());
            this.describeSignListStatusSet.forEach(d -> this.describeSignListStatus.put(((DescribeSignListStatusSetRB)d).signId, d.finishing()));
        }
    }

    public DescribeSignListStatusSetRB getDescribeSignResponse(Integer signId) {
        return this.describeSignListStatus.get(signId);
    }

    public Boolean getDescribeSignStatus(Integer signId) {
        return this.describeSignListStatus.get(signId).isAvailable;
    }

    public Boolean getStatus() {
        return this.status;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public List<DescribeSignListStatusSetRB> getDescribeSignListStatusSet() {
        return this.describeSignListStatusSet;
    }

    public void setDescribeSignListStatusSet(List<DescribeSignListStatusSetRB> describeSignListStatusSet) {
        this.describeSignListStatusSet = describeSignListStatusSet;
    }

    public ErrorRB getError() {
        return this.error;
    }

    public void setError(ErrorRB error) {
        this.error = error;
    }

    public Map<Integer, DescribeSignListStatusSetRB> getDescribeSignListStatus() {
        return this.describeSignListStatus;
    }

    public void setDescribeSignListStatus(Map<Integer, DescribeSignListStatusSetRB> describeSignListStatus) {
        this.describeSignListStatus = describeSignListStatus;
    }

    public static class DescribeSignListStatusSetRB {
        @JSONField(name="SignName")
        private String signName;
        @JSONField(name="International")
        private Integer international;
        @JSONField(name="SignId")
        private Integer signId;
        @JSONField(name="ReviewReply")
        private String reviewReply;
        @JSONField(name="CreateTime")
        private Integer createTime;
        @JSONField(name="StatusCode")
        private Integer statusCode;
        private Boolean isAvailable = false;

        public DescribeSignListStatusSetRB finishing() {
            if (this.statusCode == 0) {
                this.isAvailable = true;
            }
            return this;
        }

        public String getSignName() {
            return this.signName;
        }

        public Integer getInternational() {
            return this.international;
        }

        public Integer getSignId() {
            return this.signId;
        }

        public String getReviewReply() {
            return this.reviewReply;
        }

        public Integer getCreateTime() {
            return this.createTime;
        }

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public Boolean getIsAvailable() {
            return this.isAvailable;
        }

        public void setSignName(String signName) {
            this.signName = signName;
        }

        public void setInternational(Integer international) {
            this.international = international;
        }

        public void setSignId(Integer signId) {
            this.signId = signId;
        }

        public void setReviewReply(String reviewReply) {
            this.reviewReply = reviewReply;
        }

        public void setCreateTime(Integer createTime) {
            this.createTime = createTime;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public void setIsAvailable(Boolean isAvailable) {
            this.isAvailable = isAvailable;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DescribeSignListStatusSetRB)) {
                return false;
            }
            DescribeSignListStatusSetRB other = (DescribeSignListStatusSetRB)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$international = this.getInternational();
            Integer other$international = other.getInternational();
            if (this$international == null ? other$international != null : !((Object)this$international).equals(other$international)) {
                return false;
            }
            Integer this$signId = this.getSignId();
            Integer other$signId = other.getSignId();
            if (this$signId == null ? other$signId != null : !((Object)this$signId).equals(other$signId)) {
                return false;
            }
            Integer this$createTime = this.getCreateTime();
            Integer other$createTime = other.getCreateTime();
            if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
                return false;
            }
            Integer this$statusCode = this.getStatusCode();
            Integer other$statusCode = other.getStatusCode();
            if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
                return false;
            }
            Boolean this$isAvailable = this.getIsAvailable();
            Boolean other$isAvailable = other.getIsAvailable();
            if (this$isAvailable == null ? other$isAvailable != null : !((Object)this$isAvailable).equals(other$isAvailable)) {
                return false;
            }
            String this$signName = this.getSignName();
            String other$signName = other.getSignName();
            if (this$signName == null ? other$signName != null : !this$signName.equals(other$signName)) {
                return false;
            }
            String this$reviewReply = this.getReviewReply();
            String other$reviewReply = other.getReviewReply();
            return !(this$reviewReply == null ? other$reviewReply != null : !this$reviewReply.equals(other$reviewReply));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DescribeSignListStatusSetRB;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $international = this.getInternational();
            result = result * 59 + ($international == null ? 43 : ((Object)$international).hashCode());
            Integer $signId = this.getSignId();
            result = result * 59 + ($signId == null ? 43 : ((Object)$signId).hashCode());
            Integer $createTime = this.getCreateTime();
            result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
            Integer $statusCode = this.getStatusCode();
            result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
            Boolean $isAvailable = this.getIsAvailable();
            result = result * 59 + ($isAvailable == null ? 43 : ((Object)$isAvailable).hashCode());
            String $signName = this.getSignName();
            result = result * 59 + ($signName == null ? 43 : $signName.hashCode());
            String $reviewReply = this.getReviewReply();
            result = result * 59 + ($reviewReply == null ? 43 : $reviewReply.hashCode());
            return result;
        }

        public String toString() {
            return "SignatureValidationSmsResponse.DescribeSignListStatusSetRB(signName=" + this.getSignName() + ", international=" + this.getInternational() + ", signId=" + this.getSignId() + ", reviewReply=" + this.getReviewReply() + ", createTime=" + this.getCreateTime() + ", statusCode=" + this.getStatusCode() + ", isAvailable=" + this.getIsAvailable() + ")";
        }
    }
}

