/*
 * Decompiled with CFR 0.152.
 */
package com.ms.tools.api.tencent.sms.vo;

import com.alibaba.fastjson2.annotation.JSONField;
import com.ms.tools.api.tencent.factory.TencentCloudApiConfig;
import com.ms.tools.api.tencent.sms.vo.BasicSmsTencentVo;

public class SendSmsTencentVo {
    private final BasicSmsTencentVo basic = new BasicSmsTencentVo();
    private Send send;

    private SendSmsTencentVo() {
        this.basic.setVersion(TencentCloudApiConfig.Version.V20210111);
        this.basic.setAction(TencentCloudApiConfig.Action.SEND_SMS);
        this.basic.setRegion(TencentCloudApiConfig.Region.AP_GUANGZHOU);
    }

    public static SendSmsTencentVo build(Send send) {
        SendSmsTencentVo vo = new SendSmsTencentVo();
        vo.setSend(send);
        return vo;
    }

    public String getAction() {
        return this.basic.getAction();
    }

    public String getVersion() {
        return this.basic.getVersion();
    }

    public String getRegion() {
        return this.basic.getRegion();
    }

    public BasicSmsTencentVo getBasic() {
        return this.basic;
    }

    private void setSend(Send send) {
        this.send = send;
    }

    public static class Send {
        @JSONField(name="ExtendCode")
        private String extendCode;
        @JSONField(name="SessionContext")
        private String sessionContext;
        @JSONField(name="SignName")
        private String signName;
        @JSONField(name="TemplateId")
        private String templateId;
        @JSONField(name="SmsSdkAppId")
        private String smsSdkAppId;
        @JSONField(name="PhoneNumberSet")
        private String[] phoneNumber;
        @JSONField(name="TemplateParamSet")
        private String[] templateParam;
        @JSONField(name="SenderId")
        private String senderId;

        private Send() {
        }

        public Send(String signName, String templateId, String smsSdkAppId) {
            this();
            this.signName = signName;
            this.templateId = templateId;
            this.smsSdkAppId = smsSdkAppId;
        }

        public Send(String signName, String templateId, String smsSdkAppId, String[] phoneNumber) {
            this();
            this.signName = signName;
            this.templateId = templateId;
            this.smsSdkAppId = smsSdkAppId;
            this.phoneNumber = phoneNumber;
        }

        public Send(String signName, String templateId, String smsSdkAppId, String[] phoneNumber, String[] templateParam) {
            this();
            this.signName = signName;
            this.templateId = templateId;
            this.smsSdkAppId = smsSdkAppId;
            this.phoneNumber = phoneNumber;
            this.templateParam = templateParam;
        }

        public Send(String signName, String templateId, String smsSdkAppId, String phoneNumber, String templateParam) {
            this();
            this.signName = signName;
            this.templateId = templateId;
            this.smsSdkAppId = smsSdkAppId;
            this.phoneNumber = new String[]{phoneNumber};
            this.templateParam = new String[]{templateParam};
        }

        public Send(String signName, String templateId, String smsSdkAppId, String phoneNumber, String ... templateParam) {
            this();
            this.signName = signName;
            this.templateId = templateId;
            this.smsSdkAppId = smsSdkAppId;
            this.phoneNumber = new String[]{phoneNumber};
            this.templateParam = templateParam;
        }

        public Send build(String[] phoneNumber, String[] templateParam) {
            this.phoneNumber = phoneNumber;
            this.templateParam = templateParam;
            return this;
        }

        public Send build(String phoneNumber, String templateParam) {
            this.phoneNumber = new String[]{phoneNumber};
            this.templateParam = new String[]{templateParam};
            return this;
        }

        public Send build(String phoneNumber, String ... templateParam) {
            this.phoneNumber = new String[]{phoneNumber};
            this.templateParam = templateParam;
            return this;
        }

        public String getExtendCode() {
            return this.extendCode;
        }

        public void setExtendCode(String extendCode) {
            this.extendCode = extendCode;
        }

        public String getSessionContext() {
            return this.sessionContext;
        }

        public void setSessionContext(String sessionContext) {
            this.sessionContext = sessionContext;
        }

        public String getSignName() {
            return this.signName;
        }

        public void setSignName(String signName) {
            this.signName = signName;
        }

        public String getTemplateId() {
            return this.templateId;
        }

        public void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        public String getSmsSdkAppId() {
            return this.smsSdkAppId;
        }

        public void setSmsSdkAppId(String smsSdkAppId) {
            this.smsSdkAppId = smsSdkAppId;
        }

        public String[] getPhoneNumber() {
            return this.phoneNumber;
        }

        public void setPhoneNumber(String[] phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public String[] getTemplateParam() {
            return this.templateParam;
        }

        public void setTemplateParam(String[] templateParam) {
            this.templateParam = templateParam;
        }

        public String getSenderId() {
            return this.senderId;
        }

        public void setSenderId(String senderId) {
            this.senderId = senderId;
        }
    }
}

