/*
 * Decompiled with CFR 0.152.
 */
package io.split.api.client;

import io.split.api.SplitApiClientConfig;
import io.split.api.client.interceptors.AddSplitHeadersFilter;
import io.split.api.client.utils.Json;
import java.io.IOException;
import java.net.URI;
import split.org.apache.http.client.config.RequestConfig;
import split.org.apache.http.client.methods.CloseableHttpResponse;
import split.org.apache.http.client.methods.HttpDelete;
import split.org.apache.http.client.methods.HttpGet;
import split.org.apache.http.client.methods.HttpPost;
import split.org.apache.http.client.methods.HttpPut;
import split.org.apache.http.client.methods.HttpRequestBase;
import split.org.apache.http.entity.StringEntity;
import split.org.apache.http.impl.client.CloseableHttpClient;
import split.org.apache.http.impl.client.HttpClients;
import split.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import split.org.apache.http.util.EntityUtils;
import split.org.slf4j.Logger;
import split.org.slf4j.LoggerFactory;

public class HttpClient {
    private static final Logger _log = LoggerFactory.getLogger(HttpClient.class);
    private final CloseableHttpClient _client;
    private final URI _rootTarget;

    public HttpClient(String apiToken, SplitApiClientConfig config) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(config.connectionTimeout()).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(20);
        cm.setDefaultMaxPerRoute(20);
        this._client = HttpClients.custom().setConnectionManager(cm).setDefaultRequestConfig(requestConfig).addInterceptorLast(AddSplitHeadersFilter.instance(apiToken)).build();
        this._rootTarget = URI.create(config.endpoint());
    }

    public String get(String path, String ... arguments) {
        HttpGet request = new HttpGet(this.buildURI(path, arguments));
        return this.executeRequest(request);
    }

    public String delete(String path, String ... arguments) {
        HttpDelete request = new HttpDelete(this.buildURI(path, arguments));
        return this.executeRequest(request);
    }

    public String post(Object entity, String path, String ... arguments) {
        HttpPost request = new HttpPost(this.buildURI(path, arguments));
        request.setEntity(HttpClient.toJsonEntity(entity));
        return this.executeRequest(request);
    }

    public String put(Object entity, String path, String ... arguments) {
        HttpPut request = new HttpPut(this.buildURI(path, arguments));
        request.setEntity(HttpClient.toJsonEntity(entity));
        return this.executeRequest(request);
    }

    public String executeRequest(HttpRequestBase request) {
        String string;
        CloseableHttpResponse response = null;
        try {
            response = this._client.execute(request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                String message = String.format("Error Executing Request: method=%s path=%s status=%d", request.getMethod(), request.getURI().getPath(), statusCode);
                _log.error(message);
                throw new IllegalStateException(message);
            }
            String json = EntityUtils.toString(response.getEntity());
            if (_log.isDebugEnabled()) {
                _log.debug("Received json: " + json);
            }
            string = json;
        }
        catch (Throwable t) {
            try {
                _log.error(String.format("Error Executing Request: method=%s path=%s", request.getMethod(), request.getURI().getPath()), t);
                throw new IllegalStateException(t);
            }
            catch (Throwable throwable) {
                HttpClient.forceClose(response);
                throw throwable;
            }
        }
        HttpClient.forceClose(response);
        return string;
    }

    private URI buildURI(String pathPattern, String ... arguments) {
        String url = HttpClient.concatenateURL(this._rootTarget.toString(), String.format(pathPattern, arguments));
        return url != null ? URI.create(url) : null;
    }

    public static String concatenateURL(String ... urls) {
        if (urls.length == 0) {
            return null;
        }
        if (urls.length == 1) {
            return HttpClient.stripBackslash(urls[0]);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(HttpClient.stripBackslash(urls[0]));
        for (int i = 1; i < urls.length; ++i) {
            builder.append("/");
            builder.append(HttpClient.stripBackslash(urls[i], true));
        }
        return builder.toString();
    }

    private static String stripBackslash(String url) {
        return HttpClient.stripBackslash(url, false);
    }

    private static String stripBackslash(String url, boolean stripStarting) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        if (stripStarting && url.startsWith("/")) {
            url = url.substring(1, url.length());
        }
        return url;
    }

    private static StringEntity toJsonEntity(Object obj) {
        String json = Json.toJson(obj);
        StringEntity entity = new StringEntity(json, "UTF-8");
        entity.setContentType("application/json");
        return entity;
    }

    private static void forceClose(CloseableHttpResponse response) {
        try {
            if (response != null) {
                response.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

