/*
 * Decompiled with CFR 0.152.
 */
package io.split.api.resources;

import io.split.api.client.HttpClient;
import io.split.api.client.utils.Json;
import io.split.api.dtos.Attribute;
import io.split.api.dtos.TrafficType;
import java.util.List;

public class AttributeClient {
    private HttpClient _client;

    public AttributeClient(HttpClient client) {
        this._client = client;
    }

    public List<Attribute> list(TrafficType trafficType) {
        return this.list(trafficType.id());
    }

    public List<Attribute> list(String trafficTypeId) {
        String result = this._client.get("/v1/trafficTypes/{trafficTypeId}/schema", trafficTypeId);
        return Json.parseList(result, Attribute.class);
    }

    public Attribute create(Attribute attribute) {
        String result = this._client.put("/v1/trafficTypes/{trafficTypeId}/schema", attribute.trafficTypeId(), new String[0]);
        return Json.parse(result, Attribute.class);
    }

    public boolean delete(Attribute attribute) {
        return this.delete(attribute.trafficTypeId(), attribute.id());
    }

    public boolean delete(String trafficTypeId, String attributeId) {
        String result = this._client.get("/v1/trafficTypes/{trafficTypeId}/schema/{attributeId}", trafficTypeId, attributeId);
        return Json.parse(result, Boolean.class);
    }
}

