/*
 * Decompiled with CFR 0.152.
 */
package io.split.api.resources;

import io.split.api.client.HttpClient;
import io.split.api.client.exceptions.SplitException;
import io.split.api.client.utils.EncodingUtil;
import io.split.api.dtos.Identity;
import io.split.api.dtos.result.ResultDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IdentityClient {
    private HttpClient _client;

    public IdentityClient(HttpClient client) {
        this._client = client;
    }

    public Identity save(Identity identity) throws SplitException {
        String result = this._client.put(identity, "/v1/trafficTypes/%s/environments/%s/identities/%s", identity.trafficTypeId(), identity.environmentId(), identity.key());
        return EncodingUtil.parse(result, Identity.class);
    }

    public ResultDTO<Identity> save(Collection<Identity> identities) throws SplitException {
        HashMap groups = new HashMap();
        for (Identity identity : identities) {
            String key = String.format("%s:%s", identity.trafficTypeId(), identity.environmentId());
            if (!groups.containsKey(key)) {
                groups.put(key, new ArrayList());
            }
            ((List)groups.get(key)).add(identity);
        }
        ResultDTO<Identity> result = new ResultDTO<Identity>();
        for (Map.Entry entry : groups.entrySet()) {
            if (((List)entry.getValue()).size() == 0) continue;
            String trafficTypeId = ((Identity)((List)entry.getValue()).get(0)).trafficTypeId();
            String environmentId = ((Identity)((List)entry.getValue()).get(0)).environmentId();
            ResultDTO<Identity> groupResult = this.save(trafficTypeId, environmentId, (List)entry.getValue());
            result.objects().addAll(groupResult.objects());
            result.failed().addAll(groupResult.failed());
        }
        return result;
    }

    public ResultDTO<Identity> save(String trafficTypeId, String environmentId, List<Identity> identities) throws SplitException {
        String result = this._client.post(identities, "/v1/trafficTypes/%s/environments/%s/identities", trafficTypeId, environmentId);
        return EncodingUtil.parseResult(result, Identity.class);
    }

    public Identity update(Identity identity) throws SplitException {
        String result = this._client.post(identity, "/v1/trafficTypes/%s/environments/%s/identities/%s/patch", identity.trafficTypeId(), identity.environmentId(), identity.key());
        return EncodingUtil.parse(result, Identity.class);
    }

    public boolean delete(Identity identity) throws SplitException {
        return this.delete(identity.trafficTypeId(), identity.environmentId(), identity.key());
    }

    public boolean delete(String trafficTypeId, String environmentId, String key) throws SplitException {
        String result = this._client.delete("/v1/trafficTypes/%s/environments/%s/identities/%s", trafficTypeId, environmentId, key);
        return EncodingUtil.parse(result, Boolean.class);
    }
}

