/*
 * Decompiled with CFR 0.152.
 */
package io.split.api;

import io.split.api.SplitApiClientConfig;
import io.split.api.client.HttpClient;
import io.split.api.resources.AttributeClient;
import io.split.api.resources.EnvironmentClient;
import io.split.api.resources.IdentityClient;
import io.split.api.resources.SplitClient;
import io.split.api.resources.SplitDefinitionClient;
import io.split.api.resources.TrafficTypeClient;

public class SplitApiClient {
    private final HttpClient _httpClient;
    private final TrafficTypeClient trafficTypeClient;
    private final EnvironmentClient environmentClient;
    private final AttributeClient attributeClient;
    private final IdentityClient identityClient;
    private final SplitClient splitClient;
    private final SplitDefinitionClient splitDefinitionClient;

    public static SplitApiClient client(String apiToken) {
        return SplitApiClient.client(apiToken, SplitApiClientConfig.builder().build());
    }

    public static synchronized SplitApiClient client(String apiToken, SplitApiClientConfig config) {
        return new SplitApiClient(apiToken, config);
    }

    private SplitApiClient(String apiToken, SplitApiClientConfig config) {
        this._httpClient = new HttpClient(apiToken, config);
        this.trafficTypeClient = new TrafficTypeClient(this._httpClient);
        this.environmentClient = new EnvironmentClient(this._httpClient);
        this.attributeClient = new AttributeClient(this._httpClient);
        this.identityClient = new IdentityClient(this._httpClient);
        this.splitClient = new SplitClient(this._httpClient);
        this.splitDefinitionClient = new SplitDefinitionClient(this._httpClient);
    }

    public TrafficTypeClient trafficTypes() {
        return this.trafficTypeClient;
    }

    public EnvironmentClient environments() {
        return this.environmentClient;
    }

    public AttributeClient attributes() {
        return this.attributeClient;
    }

    public IdentityClient identities() {
        return this.identityClient;
    }

    public SplitClient split() {
        return this.splitClient;
    }

    public SplitDefinitionClient splitDefinition() {
        return this.splitDefinitionClient;
    }
}

