/*
 * Decompiled with CFR 0.152.
 */
package io.split.api;

public class SplitApiClientConfig {
    private final String _endpoint;
    private final int _connectionTimeout;
    private final boolean _debugEnabled;
    private final int _readTimeout;

    public static Builder builder() {
        return new Builder();
    }

    private SplitApiClientConfig(String endpoint, int connectionTimeout, int readTimeout, boolean debugEnabled) {
        this._endpoint = endpoint;
        this._readTimeout = readTimeout;
        this._connectionTimeout = connectionTimeout;
        this._debugEnabled = debugEnabled;
    }

    public String endpoint() {
        return this._endpoint;
    }

    public int connectionTimeout() {
        return this._connectionTimeout;
    }

    public boolean debugEnabled() {
        return this._debugEnabled;
    }

    public int readTimeout() {
        return this._readTimeout;
    }

    public static final class Builder {
        private String _endpoint = "https://api.split.io/internal/api";
        private int _connectionTimeout = 15000;
        private boolean _debugEnabled = false;
        private int _readTimeout = 15000;

        public Builder endpoint(String endpoint) {
            this._endpoint = endpoint;
            return this;
        }

        public Builder connectionTimeout(int ms) {
            this._connectionTimeout = ms;
            return this;
        }

        public Builder readTimeout(int ms) {
            this._readTimeout = ms;
            return this;
        }

        public Builder enableDebug() {
            this._debugEnabled = true;
            return this;
        }

        public SplitApiClientConfig build() {
            if (this._connectionTimeout <= 0) {
                throw new IllegalArgumentException("connectionTimeOutInMs must be > 0: " + this._connectionTimeout);
            }
            if (this._endpoint == null) {
                throw new IllegalArgumentException("endpoint must not be null");
            }
            return new SplitApiClientConfig(this._endpoint, this._connectionTimeout, this._readTimeout, this._debugEnabled);
        }
    }
}

