/*
 * Decompiled with CFR 0.152.
 */
package io.split.api.dtos.split;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.split.api.dtos.TrafficType;
import io.split.api.dtos.URN;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Split {
    private String name;
    private String description;
    private URN trafficType;
    private Long creationTime;

    public Split() {
    }

    private Split(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
        this.trafficType = builder.trafficType;
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public String description() {
        return this.description;
    }

    @JsonProperty
    public URN trafficType() {
        return this.trafficType;
    }

    @JsonProperty
    public Long creationTime() {
        return this.creationTime;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTrafficType(URN trafficType) {
        this.trafficType = trafficType;
    }

    public void setCreationTime(Long creationTime) {
        this.creationTime = creationTime != null ? creationTime : System.currentTimeMillis();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Split other) {
        return new Builder(other);
    }

    public String toString() {
        return "Split{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", trafficType=" + this.trafficType + ", creationTime=" + this.creationTime + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Split split = (Split)o;
        if (this.name != null ? !this.name.equals(split.name) : split.name != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(split.description) : split.description != null) {
            return false;
        }
        if (this.trafficType != null ? !this.trafficType.equals(split.trafficType) : split.trafficType != null) {
            return false;
        }
        return this.creationTime != null ? this.creationTime.equals(split.creationTime) : split.creationTime == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.trafficType != null ? this.trafficType.hashCode() : 0);
        result = 31 * result + (this.creationTime != null ? this.creationTime.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String name;
        private String description;
        private URN trafficType;
        private Long creationTime;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder trafficType(URN trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        public Builder trafficType(TrafficType trafficType) {
            this.trafficType = URN.builder().name(trafficType.name()).id(trafficType.id()).build();
            return this;
        }

        public Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        Builder() {
        }

        Builder(Split prototype) {
            this.name = prototype.name;
            this.description = prototype.description;
            this.trafficType = prototype.trafficType;
            this.creationTime = prototype.creationTime;
        }

        public Split build() {
            return new Split(this);
        }
    }
}

