/*
 * Decompiled with CFR 0.152.
 */
package io.split.api.client.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.split.api.client.exceptions.SplitJsonException;
import io.split.api.dtos.result.FailureDTO;
import io.split.api.dtos.result.ListResultDTO;
import io.split.api.dtos.result.ResultDTO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class EncodingUtil {
    private static final ObjectMapper _mapper = new ObjectMapper();

    public static String encode(Object object) throws SplitJsonException {
        try {
            return _mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new SplitJsonException((Exception)((Object)e));
        }
    }

    public static <T> T parse(String json, Class<T> objectType) throws SplitJsonException {
        try {
            return _mapper.readValue(json, objectType);
        }
        catch (IOException e) {
            throw new SplitJsonException(e);
        }
    }

    public static <T> List<T> parseList(String jsonString, Class<T> clazz) throws SplitJsonException {
        try {
            Iterator<JsonNode> nodes = _mapper.readValue(jsonString, JsonNode.class).elements();
            ArrayList<T> list = new ArrayList<T>();
            while (nodes.hasNext()) {
                JsonNode ni = nodes.next();
                if (ni.size() <= 0) continue;
                list.add(_mapper.readValue(ni.toString(), clazz));
            }
            return list;
        }
        catch (IOException e) {
            throw new SplitJsonException(e);
        }
    }

    public static <T> ResultDTO<T> parseResult(String jsonString, Class<T> objectType) {
        try {
            JsonNode total;
            JsonNode count;
            JsonNode limit;
            JsonNode node = _mapper.readValue(jsonString, JsonNode.class);
            ArrayList<T> successful = new ArrayList<T>();
            List<JsonNode> objectsNode = node.findValues("objects");
            if (objectsNode != null && !objectsNode.isEmpty()) {
                Iterator<JsonNode> successfulNodes = node.findValues("objects").get(0).elements();
                while (successfulNodes.hasNext()) {
                    JsonNode ni = successfulNodes.next();
                    if (ni.size() <= 0) continue;
                    successful.add(_mapper.readValue(ni.toString(), objectType));
                }
            }
            ArrayList failed = new ArrayList();
            List<JsonNode> failedNode = node.findValues("failed");
            if (failedNode != null && !failedNode.isEmpty()) {
                Iterator<JsonNode> failedNodes = failedNode.get(0).elements();
                while (failedNodes.hasNext()) {
                    JsonNode ni = failedNodes.next();
                    if (ni.size() <= 0) continue;
                    int status = ni.findValue("status").asInt();
                    String message = ni.findValue("message").asText();
                    T object = _mapper.readValue(ni.findValues("object").get(0).toString(), objectType);
                    failed.add(FailureDTO.builder().status(status).message(message).object(object).build());
                }
            }
            HashMap<String, String> metadata = new HashMap<String, String>();
            List<JsonNode> metadataNode = node.findValues("metadata");
            if (metadataNode != null && !metadata.isEmpty()) {
                _mapper.readValue(metadataNode.get(0).toString(), (TypeReference)new TypeReference<HashMap<String, String>>(){});
            }
            ResultDTO.Builder builder = ResultDTO.builder();
            JsonNode offset = node.findValue("offset");
            if (offset != null) {
                builder.offset(offset.asInt());
            }
            if ((limit = node.findValue("limit")) != null) {
                builder.limit(limit.asInt());
            }
            if ((count = node.findValue("count")) != null) {
                builder.count(count.asInt());
            }
            if ((total = node.findValue("total")) != null) {
                builder.total(total.asInt());
            }
            return builder.objects(successful).failed(failed).metadata(metadata).build();
        }
        catch (IOException e) {
            throw new SplitJsonException(e);
        }
    }

    public static <T> ListResultDTO<T> parseListResult(String jsonString, Class<T> objectType) {
        try {
            JsonNode totalCount;
            JsonNode limit;
            JsonNode node = _mapper.readValue(jsonString, JsonNode.class);
            ArrayList<T> successful = new ArrayList<T>();
            List<JsonNode> objectsNode = node.findValues("objects");
            if (objectsNode != null && !objectsNode.isEmpty()) {
                Iterator<JsonNode> successfulNodes = node.findValues("objects").get(0).elements();
                while (successfulNodes.hasNext()) {
                    JsonNode ni = successfulNodes.next();
                    if (ni.size() <= 0) continue;
                    successful.add(_mapper.readValue(ni.toString(), objectType));
                }
            }
            ListResultDTO.Builder builder = ListResultDTO.builder();
            JsonNode offset = node.findValue("offset");
            if (offset != null) {
                builder.offset(offset.asInt());
            }
            if ((limit = node.findValue("limit")) != null) {
                builder.limit(limit.asInt());
            }
            if ((totalCount = node.findValue("totalCount")) != null) {
                builder.totalCount(totalCount.asLong());
            }
            return builder.objects(successful).build();
        }
        catch (IOException e) {
            throw new SplitJsonException(e);
        }
    }
}

