/*
 * Decompiled with CFR 0.152.
 */
package io.split.api.dtos.split;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Treatment {
    private String name;
    private String description;
    private List<String> keys;
    private List<String> segments;

    public Treatment() {
    }

    private Treatment(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.keys = builder.keys;
        this.segments = builder.segments;
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public String description() {
        return this.description;
    }

    @JsonProperty
    public List<String> keys() {
        return this.keys;
    }

    @JsonProperty
    public List<String> segments() {
        return this.segments;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setKeys(List<String> keys) {
        this.keys = keys;
    }

    public void setSegments(List<String> segments) {
        this.segments = segments;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Treatment other) {
        return new Builder(other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Treatment treatment = (Treatment)o;
        if (this.name != null ? !this.name.equals(treatment.name) : treatment.name != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(treatment.description) : treatment.description != null) {
            return false;
        }
        if (this.keys != null ? !this.keys.equals(treatment.keys) : treatment.keys != null) {
            return false;
        }
        return this.segments != null ? this.segments.equals(treatment.segments) : treatment.segments == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.keys != null ? this.keys.hashCode() : 0);
        result = 31 * result + (this.segments != null ? this.segments.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Treatment{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", keys=" + this.keys + ", segments=" + this.segments + '}';
    }

    public static class Builder {
        private String name;
        private String description;
        private List<String> keys;
        private List<String> segments;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder keys(List<String> keys) {
            this.keys = keys;
            return this;
        }

        public Builder segments(List<String> segments) {
            this.segments = segments;
            return this;
        }

        Builder() {
        }

        Builder(Treatment prototype) {
            this.name = prototype.name;
            this.description = prototype.description;
            this.segments = prototype.segments;
            this.keys = prototype.keys;
        }

        public Treatment build() {
            return new Treatment(this);
        }
    }
}

