/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.testing.runner;

import io.split.client.testing.SplitClientForTest;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;

public class Scenario {
    private TreeMap<String, String> _tests;

    public Scenario() {
        this._tests = new TreeMap();
    }

    public Scenario(Scenario other) {
        this._tests = new TreeMap<String, String>(other.tests());
    }

    public SortedMap<String, String> tests() {
        return this._tests;
    }

    public void addTest(String feature, String treatment) {
        this._tests.put(feature, treatment);
    }

    public void merge(Scenario other) {
        this._tests.putAll(other.tests());
    }

    public void apply(SplitClientForTest splitClient) {
        splitClient.registerTreatments(this._tests);
    }

    public String toString() {
        String output = null;
        for (Map.Entry<String, String> entry : this._tests.entrySet()) {
            String test = entry.getKey() + "=" + entry.getValue();
            if (output != null) {
                output = output + ",";
            }
            output = output + test;
        }
        return output;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scenario scenario = (Scenario)o;
        return Objects.equals(this._tests, scenario._tests);
    }

    public int hashCode() {
        return Objects.hash(this._tests);
    }
}

