/*
 * Decompiled with CFR 0.152.
 */
package io.codigo.dtos;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.codigo.dtos.Condition;
import io.codigo.dtos.MatcherGroup;
import io.codigo.dtos.Partition;
import java.util.List;

final class AutoValue_Condition
extends Condition {
    private final MatcherGroup matcherGroup;
    private final ImmutableList<Partition> partitions;

    private AutoValue_Condition(MatcherGroup matcherGroup, ImmutableList<Partition> partitions) {
        if (matcherGroup == null) {
            throw new NullPointerException("Null matcherGroup");
        }
        this.matcherGroup = matcherGroup;
        if (partitions == null) {
            throw new NullPointerException("Null partitions");
        }
        this.partitions = partitions;
    }

    @Override
    @JsonProperty
    public MatcherGroup matcherGroup() {
        return this.matcherGroup;
    }

    @Override
    @JsonProperty
    public ImmutableList<Partition> partitions() {
        return this.partitions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Condition) {
            Condition that = (Condition)o;
            return this.matcherGroup.equals(that.matcherGroup()) && this.partitions.equals(that.partitions());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.matcherGroup.hashCode();
        h *= 1000003;
        return h ^= this.partitions.hashCode();
    }

    static final class Builder
    extends Condition.Builder {
        private MatcherGroup matcherGroup;
        private ImmutableList<Partition> partitions;

        Builder() {
        }

        Builder(Condition source) {
            this.matcherGroup = source.matcherGroup();
            this.partitions = source.partitions();
        }

        @Override
        public Condition.Builder matcherGroup(MatcherGroup matcherGroup) {
            this.matcherGroup = matcherGroup;
            return this;
        }

        @Override
        public Condition.Builder partitions(List<Partition> partitions) {
            this.partitions = ImmutableList.copyOf(partitions);
            return this;
        }

        @Override
        public Condition build() {
            String missing = "";
            if (this.matcherGroup == null) {
                missing = missing + " matcherGroup";
            }
            if (this.partitions == null) {
                missing = missing + " partitions";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Condition(this.matcherGroup, this.partitions);
        }
    }
}

