/*
 * Decompiled with CFR 0.152.
 */
package io.codigo.dtos;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.codigo.dtos.Matcher;
import io.codigo.dtos.MatcherCombiner;
import io.codigo.dtos.MatcherGroup;
import java.util.List;

final class AutoValue_MatcherGroup
extends MatcherGroup {
    private final MatcherCombiner combiner;
    private final ImmutableList<Matcher> matchers;

    private AutoValue_MatcherGroup(MatcherCombiner combiner, ImmutableList<Matcher> matchers) {
        if (combiner == null) {
            throw new NullPointerException("Null combiner");
        }
        this.combiner = combiner;
        if (matchers == null) {
            throw new NullPointerException("Null matchers");
        }
        this.matchers = matchers;
    }

    @Override
    @JsonProperty
    public MatcherCombiner combiner() {
        return this.combiner;
    }

    @Override
    @JsonProperty
    public ImmutableList<Matcher> matchers() {
        return this.matchers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MatcherGroup) {
            MatcherGroup that = (MatcherGroup)o;
            return this.combiner.equals((Object)that.combiner()) && this.matchers.equals(that.matchers());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.combiner.hashCode();
        h *= 1000003;
        return h ^= this.matchers.hashCode();
    }

    static final class Builder
    extends MatcherGroup.Builder {
        private MatcherCombiner combiner;
        private ImmutableList<Matcher> matchers;

        Builder() {
        }

        Builder(MatcherGroup source) {
            this.combiner = source.combiner();
            this.matchers = source.matchers();
        }

        @Override
        public MatcherGroup.Builder combiner(MatcherCombiner combiner) {
            this.combiner = combiner;
            return this;
        }

        @Override
        public MatcherGroup.Builder matchers(List<Matcher> matchers) {
            this.matchers = ImmutableList.copyOf(matchers);
            return this;
        }

        @Override
        public ImmutableList<Matcher> matchers() {
            if (this.matchers == null) {
                throw new IllegalStateException("Property \"matchers\" has not been set");
            }
            return this.matchers;
        }

        @Override
        public MatcherGroup build() {
            String missing = "";
            if (this.combiner == null) {
                missing = missing + " combiner";
            }
            if (this.matchers == null) {
                missing = missing + " matchers";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_MatcherGroup(this.combiner, this.matchers);
        }
    }
}

