/*
 * Decompiled with CFR 0.152.
 */
package io.codigo.dtos;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.codigo.dtos.KeyImpressionDTO;
import io.codigo.models.KeyImpression;
import io.codigo.models.TestImpressions;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonDeserialize(builder=Builder.class)
public final class TestImpressionsDTO
implements TestImpressions {
    private final String testId;
    private final String testName;
    private final List<KeyImpressionDTO> keyImpressions;

    public static Builder builder() {
        return new Builder();
    }

    private TestImpressionsDTO(@Nullable String testId, String testName, List<KeyImpressionDTO> keyImpressions) {
        this.testId = testId;
        if (testName == null) {
            throw new NullPointerException("Null testName");
        }
        this.testName = testName;
        if (keyImpressions == null) {
            throw new NullPointerException("Null keyImpressions");
        }
        this.keyImpressions = keyImpressions;
    }

    @Override
    @Nullable
    @JsonProperty
    public String testId() {
        return this.testId;
    }

    @Nullable
    @JsonProperty
    public String testName() {
        return this.testName;
    }

    @Override
    @JsonDeserialize(contentAs=KeyImpressionDTO.class)
    @JsonProperty
    public List<KeyImpression> keyImpressions() {
        return this.keyImpressions.stream().map(k -> k).collect(Collectors.toList());
    }

    @JsonIgnore
    public List<KeyImpressionDTO> keyImpressionsDTOs() {
        return this.keyImpressions;
    }

    @Override
    @JsonIgnore
    public String type() {
        return "TestImpressions";
    }

    @Override
    @JsonIgnore
    public final String id() {
        return this.testId();
    }

    public String toString() {
        return "TestImpressionsDTO{testId=" + this.testId + ", " + "testName=" + this.testName + ", " + "keyImpressions=" + this.keyImpressions + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TestImpressionsDTO) {
            TestImpressionsDTO that = (TestImpressionsDTO)o;
            return (this.testId == null ? that.testId() == null : this.testId.equals(that.testId())) && this.testName.equals(that.testName()) && this.keyImpressions.equals(that.keyImpressions());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h *= 1000003;
        h ^= this.testId == null ? 0 : this.testId.hashCode();
        h *= 1000003;
        h ^= this.testName.hashCode();
        h *= 1000003;
        return h ^= this.keyImpressions.hashCode();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private String testId;
        private String testName;
        private List<KeyImpressionDTO> keyImpressions;

        Builder() {
        }

        Builder(TestImpressions source) {
            this.testId = source.testId();
            this.keyImpressions = source.keyImpressions().stream().map(k -> KeyImpressionDTO.builder(k).build()).collect(Collectors.toList());
        }

        public Builder testId(String testId) {
            this.testId = testId;
            return this;
        }

        public Builder testName(String testName) {
            this.testName = testName;
            return this;
        }

        @JsonDeserialize(contentAs=KeyImpressionDTO.class)
        public Builder keyImpressions(List<KeyImpression> keyImpressions) {
            this.keyImpressions = keyImpressions.stream().map(k -> KeyImpressionDTO.builder(k).build()).collect(Collectors.toList());
            return this;
        }

        @JsonIgnore
        public Builder keyImpressionsDTO(List<KeyImpressionDTO> keyImpressions) {
            this.keyImpressions = keyImpressions;
            return this;
        }

        public TestImpressionsDTO build() {
            String missing = "";
            if (this.testName == null) {
                missing = missing + " testName";
            }
            if (this.keyImpressions == null) {
                missing = missing + " keyImpressions";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new TestImpressionsDTO(this.testId, this.testName, this.keyImpressions);
        }
    }
}

