/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetAddress;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddSplitHeadersFilter
implements ClientRequestFilter {
    private static final Logger _log = LoggerFactory.getLogger(AddSplitHeadersFilter.class);
    private static final String CLIENT_MACHINE_NAME_HEADER = "SplitSDKMachineName";
    private static final String CLIENT_MACHINE_IP_HEADER = "SplitSDKMachineIP";
    private static final String CLIENT_VERSION = "SplitSDKVersion";
    private final String _apiTokenBearer;
    private final String _hostname;
    private final String _ip;

    public static AddSplitHeadersFilter instance(String apiToken) {
        String hostname = null;
        String ip = null;
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            hostname = localHost.getHostName();
            ip = localHost.getHostAddress();
        }
        catch (Exception e) {
            _log.error("Could not resolve InetAddress", e);
        }
        return new AddSplitHeadersFilter(apiToken, hostname, ip);
    }

    private AddSplitHeadersFilter(String apiToken, String hostname, String ip) {
        Preconditions.checkNotNull(apiToken);
        this._apiTokenBearer = "Bearer " + apiToken;
        this._hostname = hostname;
        this._ip = ip;
    }

    @Override
    public void filter(ClientRequestContext requestContext) throws IOException {
        requestContext.getHeaders().putSingle("Authorization", this._apiTokenBearer);
        requestContext.getHeaders().putSingle(CLIENT_VERSION, "java-0.0.2");
        if (this._hostname != null) {
            requestContext.getHeaders().putSingle(CLIENT_MACHINE_NAME_HEADER, this._hostname);
        }
        if (this._ip != null) {
            requestContext.getHeaders().putSingle(CLIENT_MACHINE_IP_HEADER, this._ip);
        }
    }
}

