/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.google.common.base.Preconditions;
import io.codigo.dtos.SDKSettingsDTO;
import io.codigo.models.SDKSettings;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSDKSettingsFetcher {
    private static final Logger _log = LoggerFactory.getLogger(HttpSDKSettingsFetcher.class);
    private final WebTarget _target;

    public static HttpSDKSettingsFetcher create(WebTarget root) {
        return new HttpSDKSettingsFetcher(root.path("sdkSettings"));
    }

    private HttpSDKSettingsFetcher(WebTarget target) {
        this._target = target;
        Preconditions.checkNotNull(this._target);
    }

    public SDKSettings fetch() {
        SDKSettingsDTO result = null;
        try {
            Response response = this._target.request("application/json").get();
            if (response.getStatus() != 200) {
                _log.error("Response status was: " + response.getStatus());
                return result;
            }
            result = response.readEntity(SDKSettingsDTO.class);
            return result;
        }
        catch (Throwable t) {
            _log.error("Problem reading entity SDKSettings", t);
            return result;
        }
    }
}

