/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.split.client.TheseFeaturesAreOnSplitClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalhostSplitClientBuilder {
    private static final Logger _log = LoggerFactory.getLogger(LocalhostSplitClientBuilder.class);
    public static final String LOCALHOST = "localhost";
    public static final String FILENAME = ".split";

    public static TheseFeaturesAreOnSplitClient build() throws IOException {
        String home = System.getProperty("user.home");
        Preconditions.checkNotNull(home, "Property user.home should be set when using environment: localhost");
        return LocalhostSplitClientBuilder.build(home);
    }

    static TheseFeaturesAreOnSplitClient build(String home) throws IOException {
        _log.info("home = " + home);
        BufferedReader reader = null;
        String fileName = home + "/" + FILENAME;
        HashSet<String> onSplits = Sets.newHashSet();
        try {
            reader = new BufferedReader(new FileReader(new File(fileName)));
            String line = reader.readLine();
            while (line != null) {
                if (!(line = line.trim()).isEmpty() && !line.startsWith("#") && onSplits.add(line)) {
                    _log.info("Split: " + line + " will be on for 100% of your users");
                }
                line = reader.readLine();
            }
        }
        catch (FileNotFoundException e) {
            _log.warn("There was no file named " + fileName + " found. " + "We created a split client that considers all partitions to be off for all of your users. " + "If you wish to turn on a split, enter the name of that split in " + fileName + "; one split per line. Whitelines are fine. Lines starting with '#' are considered comments");
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return new TheseFeaturesAreOnSplitClient(onSplits);
    }
}

