/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.codigo.grammar.Treatments;
import io.split.client.SplitClient;
import io.split.engine.experiments.ParsedCondition;
import io.split.engine.experiments.ParsedSplit;
import io.split.engine.experiments.SplitFetcher;
import io.split.engine.impressions.TreatmentLog;
import io.split.engine.metrics.Metrics;
import io.split.engine.splitter.Splitter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SplitClientImpl
implements SplitClient {
    private static final Logger _log = LoggerFactory.getLogger(SplitClientImpl.class);
    private final SplitFetcher _splitFetcher;
    private final TreatmentLog _treatmentLog;
    private final Metrics _metrics;

    public SplitClientImpl(SplitFetcher splitFetcher, TreatmentLog treatmentLog, Metrics metrics) {
        this._splitFetcher = splitFetcher;
        this._treatmentLog = treatmentLog;
        this._metrics = metrics;
        Preconditions.checkNotNull(this._splitFetcher);
        Preconditions.checkNotNull(this._treatmentLog);
    }

    @Override
    public boolean isOn(String type, String id, String feature) {
        boolean isOn = false;
        try {
            long start = System.currentTimeMillis();
            String treatment = this.getTreatment(type, id, feature);
            boolean bl = isOn = !Treatments.isControl(treatment);
            if (isOn) {
                this._treatmentLog.log(id, feature, treatment, System.currentTimeMillis());
            }
            this._metrics.time("sdk.isOn", System.currentTimeMillis() - start);
            return isOn;
        }
        catch (Throwable t) {
            _log.error("MUST NOT throw this exception", t);
            return isOn;
        }
    }

    private List<String> areOnWithoutExceptionHandling(String userId) {
        ArrayList<String> on = Lists.newArrayList();
        try {
            for (ParsedSplit parsedSplit : this._splitFetcher.fetchAll()) {
                String treatment = this.getTreatment(userId, parsedSplit);
                if (Treatments.isControl(treatment)) continue;
                on.add(parsedSplit.feature());
            }
        }
        catch (Throwable t) {
            _log.error("sdk.areOn had an exception", t);
        }
        return on;
    }

    private String getTreatment(String type, String id, String feature) {
        if (id == null) {
            _log.warn("id was null for feature: " + feature);
            return "control";
        }
        if (type == null) {
            _log.warn("type was null for feature: " + feature);
            return "control";
        }
        if (feature == null) {
            _log.warn("feature was null for id: " + id);
            return "control";
        }
        try {
            String treatment = this.getTreatmentWithoutExceptionHandling(type, id, feature);
            return treatment == null ? "control" : treatment;
        }
        catch (Throwable t) {
            _log.error("Exception", t);
            return "control";
        }
    }

    private String getTreatmentWithoutExceptionHandling(String type, String id, String feature) {
        ParsedSplit experiment = this._splitFetcher.fetch(feature);
        if (experiment == null) {
            return "control";
        }
        if (!type.equalsIgnoreCase(experiment.type())) {
            return "control";
        }
        return this.getTreatment(id, experiment);
    }

    private String getTreatment(String userId, ParsedSplit experiment) {
        for (ParsedCondition parsedCondition : experiment.matcherAndSplits()) {
            if (!parsedCondition.matcher().match(userId)) continue;
            return Splitter.getTreatment(userId, experiment.seed(), parsedCondition.partitions());
        }
        return "control";
    }
}

