/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.experiments;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.split.engine.experiments.RefreshableSplitFetcher;
import io.split.engine.experiments.SplitChangeFetcher;
import io.split.engine.experiments.SplitParser;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshableSplitFetcherProvider {
    private static final Logger _log = LoggerFactory.getLogger(RefreshableSplitFetcherProvider.class);
    private final SplitParser _splitParser;
    private final SplitChangeFetcher _splitChangeFetcher;
    private final AtomicLong _refreshEveryNSeconds;
    private final AtomicReference<RefreshableSplitFetcher> _splitFetcher = new AtomicReference();
    private final Object _lock = new Object();

    public RefreshableSplitFetcherProvider(SplitChangeFetcher splitChangeFetcher, SplitParser splitParser, long refreshEveryNSeconds) {
        this._splitChangeFetcher = splitChangeFetcher;
        Preconditions.checkNotNull(this._splitChangeFetcher);
        this._splitParser = splitParser;
        Preconditions.checkNotNull(this._splitParser);
        Preconditions.checkArgument(refreshEveryNSeconds >= 0L);
        this._refreshEveryNSeconds = new AtomicLong(refreshEveryNSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefreshableSplitFetcher getFetcher() {
        if (this._splitFetcher.get() != null) {
            return this._splitFetcher.get();
        }
        Object object = this._lock;
        synchronized (object) {
            if (this._splitFetcher.get() != null) {
                return this._splitFetcher.get();
            }
            ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder();
            threadFactoryBuilder.setDaemon(true);
            threadFactoryBuilder.setNameFormat("split-splitFetcher-%d");
            final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(threadFactoryBuilder.build());
            RefreshableSplitFetcher splitFetcher = new RefreshableSplitFetcher(this._splitChangeFetcher, this._splitParser);
            scheduledExecutorService.scheduleWithFixedDelay(splitFetcher, 0L, this._refreshEveryNSeconds.get(), TimeUnit.SECONDS);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    scheduledExecutorService.shutdown();
                    try {
                        if (!scheduledExecutorService.awaitTermination(2L, TimeUnit.SECONDS)) {
                            _log.info("Executor did not terminate in the specified time.");
                            List<Runnable> droppedTasks = scheduledExecutorService.shutdownNow();
                            _log.info("Executor was abruptly shut down. These tasks will not be executed: " + droppedTasks);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            });
            this._splitFetcher.set(splitFetcher);
            return splitFetcher;
        }
    }
}

