/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.segments;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.codigo.dtos.SegmentChange;
import io.split.engine.segments.Segment;
import io.split.engine.segments.SegmentChangeFetcher;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshableSegment
implements Runnable,
Segment {
    private static final Logger _log = LoggerFactory.getLogger(RefreshableSegment.class);
    private final String _segmentName;
    private final SegmentChangeFetcher _segmentChangeFetcher;
    private final AtomicLong _changeNumber;
    private Set<String> _concurrentKeySet = Sets.newConcurrentHashSet();
    private final Object _lock = new Object();

    @Override
    public String segmentName() {
        return this._segmentName;
    }

    @Override
    public boolean contains(String key) {
        return this._concurrentKeySet.contains(key);
    }

    Set<String> fetch() {
        return Collections.unmodifiableSet(this._concurrentKeySet);
    }

    @Override
    public void forceRefresh() {
        this.run();
    }

    public long changeNumber() {
        return this._changeNumber.get();
    }

    public static RefreshableSegment create(String segmentName, SegmentChangeFetcher segmentChangeFetcher) {
        return new RefreshableSegment(segmentName, segmentChangeFetcher, -1L);
    }

    public RefreshableSegment(String segmentName, SegmentChangeFetcher segmentChangeFetcher, long changeNumber) {
        this._segmentName = segmentName;
        this._segmentChangeFetcher = segmentChangeFetcher;
        this._changeNumber = new AtomicLong(changeNumber);
        Preconditions.checkNotNull(this._segmentChangeFetcher);
        Preconditions.checkNotNull(this._segmentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long start = this._changeNumber.get();
        try {
            this.runWithoutExceptionHandling();
        }
        catch (Throwable t) {
            _log.error("RefreshableSegmentFetcher failed", t);
        }
        finally {
            _log.info(this._segmentName + " segment fetch before: " + start + ", after: " + this._changeNumber.get() + " size: " + this._concurrentKeySet.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithoutExceptionHandling() {
        SegmentChange change = this._segmentChangeFetcher.fetch(this._segmentName, this._changeNumber.get());
        if (change.till() == this._changeNumber.get()) {
            return;
        }
        if (change.since() != this._changeNumber.get() || change.since() < this._changeNumber.get()) {
            return;
        }
        if (change.added().isEmpty() && change.removed().isEmpty()) {
            this._changeNumber.set(change.till());
            return;
        }
        Object object = this._lock;
        synchronized (object) {
            if (change.since() != this._changeNumber.get() || change.till() < this._changeNumber.get()) {
                return;
            }
            for (String added : change.added()) {
                this._concurrentKeySet.add(added);
            }
            for (String removed : change.removed()) {
                this._concurrentKeySet.remove(removed);
            }
            this._changeNumber.set(change.till());
        }
    }

    public String toString() {
        return "RefreshableSegmentFetcher[" + this._segmentName + "]";
    }
}

