/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.splitter;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import io.codigo.dtos.Partition;
import io.split.engine.splitter.NumberLine;
import java.nio.charset.Charset;
import java.util.List;

public class Splitter {
    public static String getTreatment(String key, int seed, List<Partition> partitions) {
        if (partitions.isEmpty()) {
            return "control";
        }
        if (Splitter.hundredPercentOneTreatment(partitions)) {
            return partitions.get(0).treatment();
        }
        HashFunction hashFunction = Hashing.murmur3_128(seed);
        return Splitter.getTreatment(key, hashFunction, partitions);
    }

    private static String getTreatment(String key, HashFunction hashFunction, List<Partition> partitions) {
        HashCode hashCode = hashFunction.hashString(key, Charset.forName("UTF-8"));
        long hashedKey = hashCode.padToLong();
        long[] numberLine = NumberLine.NUMBER_LINE_WITH_100_BUCKETS;
        int bucketForThisKey = -1;
        for (int i = 0; i < numberLine.length; ++i) {
            if (hashedKey > numberLine[i]) continue;
            bucketForThisKey = i + 1;
            break;
        }
        int bucketsCoveredThusFar = 0;
        for (Partition partition : partitions) {
            if ((bucketsCoveredThusFar += partition.size()) < bucketForThisKey) continue;
            return partition.treatment();
        }
        return "control";
    }

    private static boolean hundredPercentOneTreatment(List<Partition> partitions) {
        if (partitions.size() != 1) {
            return false;
        }
        return partitions.get(0).size() == 100;
    }
}

