/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.experiments;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.codigo.dtos.Condition;
import io.codigo.dtos.Matcher;
import io.codigo.dtos.MatcherGroup;
import io.codigo.dtos.Partition;
import io.codigo.dtos.Split;
import io.codigo.models.Status;
import io.split.engine.experiments.ParsedCondition;
import io.split.engine.experiments.ParsedSplit;
import io.split.engine.matchers.AllKeysMatcher;
import io.split.engine.matchers.CombiningMatcher;
import io.split.engine.matchers.NegationMatcher;
import io.split.engine.matchers.UserDefinedSegmentMatcher;
import io.split.engine.matchers.WhitelistMatcher;
import io.split.engine.segments.Segment;
import io.split.engine.segments.SegmentFetcher;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SplitParser {
    private static final Logger _log = LoggerFactory.getLogger(SplitParser.class);
    private SegmentFetcher _segmentFetcher;

    public SplitParser(SegmentFetcher segmentFetcher) {
        this._segmentFetcher = segmentFetcher;
        Preconditions.checkNotNull(this._segmentFetcher);
    }

    public ParsedSplit parse(Split split) {
        try {
            return this.parseWithoutExceptionHandling(split);
        }
        catch (Throwable t) {
            _log.error("Could not parse experiment: " + split, t);
            return null;
        }
    }

    private ParsedSplit parseWithoutExceptionHandling(Split split) {
        if (split.status() != Status.ACTIVE) {
            return null;
        }
        ArrayList<ParsedCondition> parsedConditionList = Lists.newArrayList();
        for (Condition condition : split.conditions()) {
            ImmutableList<Partition> partitions = condition.partitions();
            io.split.engine.matchers.Matcher matcher = this.toMatcher(condition.matcherGroup());
            parsedConditionList.add(new ParsedCondition(matcher, partitions));
        }
        return new ParsedSplit(split.trafficTypeName(), split.name(), split.seed(), parsedConditionList);
    }

    private io.split.engine.matchers.Matcher toMatcher(MatcherGroup matcherGroup) {
        ImmutableList<Matcher> matchers = matcherGroup.matchers();
        Preconditions.checkArgument(!matchers.isEmpty());
        if (matchers.size() == 1) {
            return this.toMatcher((Matcher)matchers.get(0));
        }
        ArrayList<io.split.engine.matchers.Matcher> toCombine = Lists.newArrayList();
        for (Matcher matcher : matchers) {
            toCombine.add(this.toMatcher(matcher));
        }
        return new CombiningMatcher(matcherGroup.combiner(), toCombine);
    }

    private io.split.engine.matchers.Matcher toMatcher(Matcher matcher) {
        io.split.engine.matchers.Matcher delegate = null;
        switch (matcher.matcherType()) {
            case ALL_KEYS: {
                delegate = new AllKeysMatcher();
                break;
            }
            case IN_SEGMENT: {
                Preconditions.checkNotNull(matcher.userDefinedSegmentMatcherData());
                Segment segment = this._segmentFetcher.segment(matcher.userDefinedSegmentMatcherData().segmentName());
                delegate = new UserDefinedSegmentMatcher(segment);
                break;
            }
            case WHITELIST: {
                Preconditions.checkNotNull(matcher.whitelistMatcherData());
                delegate = new WhitelistMatcher(matcher.whitelistMatcherData().whitelist());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown matcher type: " + (Object)((Object)matcher.matcherType()));
            }
        }
        Preconditions.checkNotNull(delegate, "We were not able to create a matcher for: " + (Object)((Object)matcher.matcherType()));
        if (matcher.negate()) {
            return new NegationMatcher(delegate);
        }
        return delegate;
    }
}

