/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.impressions;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.collect.Lists;
import io.codigo.dtos.KeyImpressionDTO;
import io.split.engine.impressions.TreatmentLog;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class CachedTreatmentLog
implements TreatmentLog {
    private final Cache<String, List<KeyImpressionDTO>> _cache;
    private final int _maximumNumberOfKeysToCachePerTest;

    public static CachedTreatmentLog instance(long expireAfterWriteSeconds, int maxNumOfKeysToCachePerTest, RemovalListener<String, List<KeyImpressionDTO>> removalListener) {
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(expireAfterWriteSeconds, TimeUnit.SECONDS).removalListener(removalListener).build();
        return new CachedTreatmentLog(cache, maxNumOfKeysToCachePerTest);
    }

    private CachedTreatmentLog(Cache cache, int maximumNumberOfKeysToCachePerTest) {
        this._maximumNumberOfKeysToCachePerTest = maximumNumberOfKeysToCachePerTest;
        this._cache = cache;
        Preconditions.checkNotNull(this._cache);
        Preconditions.checkArgument(this._maximumNumberOfKeysToCachePerTest >= 0, "MaximumNumberOfKeysToCachePerTest cannot be negative");
    }

    @Override
    public void log(String id, String feature, String treatment, long time) {
        List<KeyImpressionDTO> impressions = this._cache.getIfPresent(feature);
        if (impressions == null) {
            impressions = Collections.synchronizedList(Lists.newArrayListWithCapacity(this._maximumNumberOfKeysToCachePerTest));
            impressions.add(this.keyImpressionDTO(id, treatment, time));
            this._cache.put(feature, impressions);
        } else if (impressions.size() >= this._maximumNumberOfKeysToCachePerTest) {
            this._cache.invalidate(feature);
            impressions = Collections.synchronizedList(Lists.newArrayListWithCapacity(this._maximumNumberOfKeysToCachePerTest));
            impressions.add(this.keyImpressionDTO(id, treatment, time));
            this._cache.put(feature, impressions);
        } else {
            impressions.add(this.keyImpressionDTO(id, treatment, time));
        }
    }

    private KeyImpressionDTO keyImpressionDTO(String key, String treatment, long time) {
        return KeyImpressionDTO.builder().keyName(key).treatment(treatment).time(time).build();
    }
}

