/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.segments;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.split.engine.segments.RefreshableSegment;
import io.split.engine.segments.SegmentChangeFetcher;
import io.split.engine.segments.SegmentFetcher;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshableSegmentFetcher
implements SegmentFetcher {
    private static final Logger _log = LoggerFactory.getLogger(RefreshableSegmentFetcher.class);
    private final SegmentChangeFetcher _segmentChangeFetcher;
    private final AtomicLong _refreshEveryNSeconds;
    private final Object _lock = new Object();
    private final ConcurrentMap<String, RefreshableSegment> _segmentFetchers = Maps.newConcurrentMap();
    private final ScheduledExecutorService _scheduledExecutorService;

    public RefreshableSegmentFetcher(SegmentChangeFetcher segmentChangeFetcher, long refreshEveryNSeconds, int numThreads) {
        this._segmentChangeFetcher = segmentChangeFetcher;
        Preconditions.checkNotNull(this._segmentChangeFetcher);
        Preconditions.checkArgument(refreshEveryNSeconds >= 0L);
        this._refreshEveryNSeconds = new AtomicLong(refreshEveryNSeconds);
        ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder();
        threadFactoryBuilder.setDaemon(true);
        threadFactoryBuilder.setNameFormat("split-segmentFetcher-%d");
        this._scheduledExecutorService = Executors.newScheduledThreadPool(numThreads, threadFactoryBuilder.build());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (RefreshableSegmentFetcher.this._scheduledExecutorService == null) {
                    return;
                }
                RefreshableSegmentFetcher.this._scheduledExecutorService.shutdown();
                try {
                    if (!RefreshableSegmentFetcher.this._scheduledExecutorService.awaitTermination(2L, TimeUnit.SECONDS)) {
                        _log.info("Executor did not terminate in the specified time.");
                        List<Runnable> droppedTasks = RefreshableSegmentFetcher.this._scheduledExecutorService.shutdownNow();
                        _log.info("Executor was abruptly shut down. These tasks will not be executed: " + droppedTasks);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RefreshableSegment segment(String segmentName) {
        RefreshableSegment segmentFetcher = (RefreshableSegment)this._segmentFetchers.get(segmentName);
        if (segmentFetcher != null) {
            return segmentFetcher;
        }
        Object object = this._lock;
        synchronized (object) {
            segmentFetcher = (RefreshableSegment)this._segmentFetchers.get(segmentName);
            if (segmentFetcher != null) {
                return segmentFetcher;
            }
            segmentFetcher = RefreshableSegment.create(segmentName, this._segmentChangeFetcher);
            this._scheduledExecutorService.scheduleWithFixedDelay(segmentFetcher, 0L, this._refreshEveryNSeconds.get(), TimeUnit.SECONDS);
            this._segmentFetchers.put(segmentName, segmentFetcher);
            return segmentFetcher;
        }
    }
}

