/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.core.Context;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.InjecteeImpl;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.hk2.utilities.cache.Cache;
import org.glassfish.hk2.utilities.cache.Computable;
import org.glassfish.jersey.internal.util.ReflectionHelper;

@Singleton
public class ContextInjectionResolver
implements InjectionResolver<Context> {
    @Inject
    private ServiceLocator serviceLocator;
    private final Cache<Injectee, ActiveDescriptor<?>> descriptorCache = new Cache(new Computable<Injectee, ActiveDescriptor<?>>(){

        @Override
        public ActiveDescriptor<?> compute(Injectee key) {
            return ContextInjectionResolver.this.serviceLocator.getInjecteeDescriptor(key);
        }
    });

    @Override
    public Object resolve(Injectee injectee, ServiceHandle<?> root) {
        Type requiredType = injectee.getRequiredType();
        boolean isHk2Factory = ReflectionHelper.isSubClassOf(requiredType, Factory.class);
        Injectee newInjectee = isHk2Factory ? this.getInjectee(injectee, ReflectionHelper.getTypeArgument(requiredType, 0)) : injectee;
        ActiveDescriptor<?> ad = this.descriptorCache.compute(newInjectee);
        if (ad != null) {
            ServiceHandle<?> handle = this.serviceLocator.getServiceHandle(ad, newInjectee);
            if (isHk2Factory) {
                return this.asFactory(handle);
            }
            return handle.getService();
        }
        return null;
    }

    private Factory asFactory(final ServiceHandle handle) {
        return new Factory(){

            public Object provide() {
                return handle.getService();
            }

            public void dispose(Object instance) {
            }
        };
    }

    private Injectee getInjectee(Injectee injectee, Type requiredType) {
        return new RequiredTypeOverridingInjectee(injectee, requiredType);
    }

    @Override
    public boolean isConstructorParameterIndicator() {
        return true;
    }

    @Override
    public boolean isMethodParameterIndicator() {
        return false;
    }

    private static class RequiredTypeOverridingInjectee
    extends InjecteeImpl {
        private static final long serialVersionUID = -3740895548611880187L;

        private RequiredTypeOverridingInjectee(Injectee injectee, Type requiredType) {
            super(injectee);
            this.setRequiredType(requiredType);
        }
    }

    public static final class Binder
    extends AbstractBinder {
        @Override
        protected void configure() {
            this.bind(ContextInjectionResolver.class).to(new TypeLiteral<InjectionResolver<Context>>(){}).in(Singleton.class);
        }
    }
}

