/*
 * Decompiled with CFR 0.152.
 */
package io.codigo.dtos;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Preconditions;
import io.codigo.dtos.AutoValue_Matcher;
import io.codigo.dtos.BetweenMatcherData;
import io.codigo.dtos.DataType;
import io.codigo.dtos.KeySelector;
import io.codigo.dtos.MatcherType;
import io.codigo.dtos.UnaryNumericMatcherData;
import io.codigo.dtos.UnaryStringMatcherData;
import io.codigo.dtos.UserDefinedSegmentMatcherData;
import io.codigo.dtos.WhitelistMatcherData;
import javax.annotation.Nullable;

@JsonDeserialize(builder=AutoValue_Matcher.Builder.class)
public abstract class Matcher {
    public static Builder builder() {
        return new AutoValue_Matcher.Builder().negate(false);
    }

    Matcher() {
    }

    @Nullable
    @JsonProperty
    public abstract KeySelector keySelector();

    @JsonProperty
    public abstract MatcherType matcherType();

    @JsonProperty
    public abstract boolean negate();

    @JsonProperty
    @Nullable
    public abstract UserDefinedSegmentMatcherData userDefinedSegmentMatcherData();

    @JsonProperty
    @Nullable
    public abstract WhitelistMatcherData whitelistMatcherData();

    @JsonProperty
    @Nullable
    public abstract UnaryNumericMatcherData unaryNumericMatcherData();

    @JsonProperty
    @Nullable
    public abstract BetweenMatcherData betweenMatcherData();

    @JsonProperty
    @Nullable
    public abstract UnaryStringMatcherData unaryStringMatcherData();

    public final String toString() {
        StringBuilder bldr = new StringBuilder();
        if (this.keySelector() != null) {
            bldr.append(this.keySelector().trafficType());
            if (this.keySelector().attribute() != null) {
                bldr.append(".");
                bldr.append(this.keySelector().attribute());
            }
        } else {
            bldr.append("user");
        }
        bldr.append(" is ");
        switch (this.matcherType()) {
            case WHITELIST: {
                bldr.append("in ");
                bldr.append("[");
                int count = 0;
                for (String item : this.whitelistMatcherData().whitelist()) {
                    if (count != 0) {
                        bldr.append(", ");
                    }
                    bldr.append(item);
                    ++count;
                }
                bldr.append("]");
                return bldr.toString();
            }
            case IN_SEGMENT: {
                bldr.append(" in segment ");
                bldr.append(this.userDefinedSegmentMatcherData().segmentName());
                return bldr.toString();
            }
            case ALL_KEYS: {
                bldr.append("in segment all");
                return bldr.toString();
            }
            case EQUAL_TO: {
                bldr.append("== ");
                bldr.append(this.unaryNumericMatcherData().value());
                return bldr.toString();
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                bldr.append(">= ");
                bldr.append(this.unaryNumericMatcherData().value());
                return bldr.toString();
            }
            case LESS_THAN_OR_EQUAL_TO: {
                bldr.append("<= ");
                bldr.append(this.unaryNumericMatcherData().value());
                return bldr.toString();
            }
            case BETWEEN: {
                bldr.append("between ");
                bldr.append(this.betweenMatcherData().start());
                bldr.append(" and ");
                bldr.append(this.betweenMatcherData().end());
                return bldr.toString();
            }
            case IS_STRING: {
                bldr.append(this.unaryStringMatcherData().value());
                return bldr.toString();
            }
        }
        throw new IllegalArgumentException("Cannot tell what type: " + (Object)((Object)this.matcherType()));
    }

    @JsonIgnore
    public final DataType getDataType() {
        switch (this.matcherType()) {
            case EQUAL_TO: 
            case GREATER_THAN_OR_EQUAL_TO: 
            case LESS_THAN_OR_EQUAL_TO: {
                DataType result = this.unaryNumericMatcherData().dataType();
                return result == null ? DataType.NUMBER : result;
            }
            case BETWEEN: {
                DataType result = this.betweenMatcherData().dataType();
                return result == null ? DataType.NUMBER : result;
            }
        }
        return DataType.STRING;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static abstract class Builder {
        public abstract Builder keySelector(KeySelector var1);

        public abstract Builder negate(boolean var1);

        public abstract Builder matcherType(MatcherType var1);

        public abstract MatcherType matcherType();

        public abstract Builder userDefinedSegmentMatcherData(UserDefinedSegmentMatcherData var1);

        public abstract UserDefinedSegmentMatcherData userDefinedSegmentMatcherData();

        public abstract Builder whitelistMatcherData(WhitelistMatcherData var1);

        public abstract WhitelistMatcherData whitelistMatcherData();

        public abstract Builder unaryNumericMatcherData(UnaryNumericMatcherData var1);

        public abstract UnaryNumericMatcherData unaryNumericMatcherData();

        public abstract Builder betweenMatcherData(BetweenMatcherData var1);

        public abstract BetweenMatcherData betweenMatcherData();

        public abstract Builder unaryStringMatcherData(UnaryStringMatcherData var1);

        public abstract UnaryStringMatcherData unaryStringMatcherData();

        abstract Matcher autobuild();

        public final Matcher build() {
            Matcher matcher = this.autobuild();
            switch (matcher.matcherType()) {
                case ALL_KEYS: {
                    Preconditions.checkArgument(matcher.userDefinedSegmentMatcherData() == null, "MatcherType is " + (Object)((Object)matcher.matcherType()) + ". matcher.userDefinedSegmentMatcherData() MUST BE null");
                    Preconditions.checkArgument(matcher.whitelistMatcherData() == null, "MatcherType is " + (Object)((Object)matcher.matcherType()) + ". matcher.whitelistMatcherData() MUST BE null");
                    break;
                }
                case IN_SEGMENT: {
                    Preconditions.checkArgument(matcher.userDefinedSegmentMatcherData() != null, "MatcherType is " + (Object)((Object)matcher.matcherType()) + ". matcher.userDefinedSegmentMatcherData() MUST NOT BE null");
                    Preconditions.checkArgument(matcher.whitelistMatcherData() == null, "MatcherType is " + (Object)((Object)matcher.matcherType()) + ". matcher.whitelistMatcherData() MUST BE null");
                    break;
                }
                case WHITELIST: {
                    Preconditions.checkArgument(matcher.whitelistMatcherData() != null, "MatcherType is " + (Object)((Object)matcher.matcherType()) + ". matcher.whitelistMatcherData() MUST NOT BE null");
                    Preconditions.checkArgument(matcher.userDefinedSegmentMatcherData() == null, "MatcherType is " + (Object)((Object)matcher.matcherType()) + ". matcher.userDefinedSegmentMatcherData() MUST BE null");
                    break;
                }
                case EQUAL_TO: 
                case GREATER_THAN_OR_EQUAL_TO: 
                case LESS_THAN_OR_EQUAL_TO: {
                    Preconditions.checkNotNull(matcher.unaryNumericMatcherData(), "We do not know what number to compare against");
                    break;
                }
                case BETWEEN: {
                    Preconditions.checkNotNull(matcher.betweenMatcherData(), "We do not start and end for between matcher");
                    break;
                }
                case IS_STRING: {
                    Preconditions.checkNotNull(matcher.unaryStringMatcherData(), "We do not have the string to match up with");
                }
            }
            return matcher;
        }
    }
}

